package org.lsst.ccs.subsystem.ccob;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.utilities.logging.Logger;

public class CCOBMainModule implements HasLifecycle {
    
    /* A Logger for all the subsystem CCOB.*/
    public static final Logger ccobLog = Logger.getLogger("org.lsst.ccs.subsystems.ccob");
    
    public CCOBMainModule() {
    }
    
    @LookupName
    private String name;
    
    @LookupField(strategy=Strategy.CHILDREN)
    private CCOBCommands driver;
    
    @LookupField(strategy=Strategy.CHILDREN)
    Led led;
    
    @LookupField(strategy=Strategy.CHILDREN)
    Shutter shutter;
    Thermometer thermometer;

    // -- HasLifecycle callbacks -----------------------------------------------
    @Override
    public void init() {
        try {
            driver.init();
            ccobLog.info("connection established");
        } catch (Exception ex) {
            throw new RuntimeException("cannot establish connection with ccob driver", ex);
        }
    }
    
    @Override
    public void start() {
        ccobLog.info("ccob subsystem started");
    }
    
    /**
     ***************************************************************************
     **
     ** CCOB testbench high level commands.
     **
     ***************************************************************************
     */
    
    @Command
    public CCOBDataRead getADCValues() throws DriverException {
        return driver.getAdcValues();
    }
    
    /**
     * Turn On the led. 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Turn On the led.")
    public void turnOnLed() {
        led.turnOn();
    }

    /**
     * Turn Off the led. 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Turn Off the led.")   
    public void turnOffLed() {
        led.turnOff();
    }

    /**
     * Open the shutter. 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Open the shutter.")
    public void openShutter() {
        shutter.open();
    }

    /**
     * Close the shutter. 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Close the shutter.")
    public void closeShutter() {
        shutter.close();
    }
 
    /**
     * Take an image. 
     */
    @Command(type=Command.CommandType.ACTION, level=Command.ENGINEERING1, 
            description="Take an image.")
    public void takeImage() {
        
    }
    
    /**
     * Read temperature on the thermometer and returns its values in decimal format.
     * @return temperature
     */
    @Command(type=Command.CommandType.QUERY, level=Command.ENGINEERING1, 
            description="Read temperature on the gauge and returns its values "
                    + "in decimal format.")
    public double readTemperature()  {
        return this.thermometer.readTemperature();
    }
    
       

}
