package org.lsst.ccs.subsystem.ccob;

import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupField.Strategy;
import org.lsst.ccs.drivers.ccob.CCOBDataRead;
import org.lsst.ccs.drivers.ccob.CCOBCommands;
import org.lsst.ccs.monitor.Device;

/**
 * A device around a CCOB driver
 * @author LSST CCS Team
 */
public class CCOBDevice extends Device {

    @LookupField(strategy=Strategy.TREE)
    private CCOBCommands driver;
    
    private CCOBDataRead readValues;
    
    @Override
    protected void initialize() {
            setOnline(true);
    }

    @Override
    public void readChannelGroup() {
        try {
            readValues = driver.getAdcValues();
        } catch (Exception ex) {
            log.error("error reading channel group", ex);
            throw new RuntimeException("cannot read channels", ex);
        }
    }
    
    @Override
    public double readChannel(int hwChan, int type) {
        switch(hwChan) {
            case 0 : return readValues.getLedVoltage();
            case 1 : return readValues.getLedCurrent();
            case 2 : return readValues.getLedVref();
            case 3 : return readValues.getTempLed1();
            case 4 : return readValues.getTempLed2();
            case 5 : return readValues.getPhotodiodeCurrent();
            case 6 : return readValues.getTempSphere();
            case 7 : return readValues.getTempBrd();
        }
        return Double.NaN;
    }

    @Override
    protected void close() {
        // Nothing to do. The driver's lifecycle is handled by CCOBMainModule
    }
    
    
    
}
