/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import java.lang.reflect.Constructor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Device
implements HardwareController,
HasLifecycle {
    protected String fullName;
    protected BitSet chanMask;
    protected boolean disabled;
    protected boolean inited;
    protected boolean online;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;
    protected Logger log;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected final Map<String, Control> ctlChans = new HashMap<String, Control>();
    protected int lineMask;
    protected int lineWarm;
    protected int lineState;
    @LookupField(strategy=LookupField.Strategy.TOP)
    protected Subsystem s;
    @LookupName
    protected String name;

    @Override
    public void init() {
        this.log = this.mon.subsys.getLogger();
        this.initDevice();
    }

    protected void initDevice() {
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isOnline() {
        return this.online;
    }

    public void disable() {
        this.disabled = true;
        this.setOnline(false);
    }

    public void enable() {
        this.disabled = false;
        this.checkOnline();
    }

    protected void configure(Monitor mon) {
        this.chanMask = new BitSet(mon.getNumChans());
        for (Control ctl : this.ctlChans.values()) {
            ctl.configure(mon, this);
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        return new int[]{0, 0};
    }

    protected abstract void initialize();

    protected abstract void close();

    protected void initSensors() {
        int id = this.chanMask.nextSetBit(0);
        while (id >= 0) {
            this.mon.getChannel(id).initSensor();
            id = this.chanMask.nextSetBit(id + 1);
        }
    }

    protected void initChannel(int hwChan, int type, int subtype) {
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        this.initChannel(hwChan, type, subtype);
    }

    protected void addChannel(int id) {
        this.chanMask.set(id);
    }

    protected void dropChannel(int id) {
        this.chanMask.clear(id);
        BitSet mask = new BitSet(id);
        mask.set(id);
        this.mon.setOnline(mask, false);
        this.mon.getChannel(id).setValid(false);
    }

    public void checkOnline() {
        if (this.online || this.disabled) {
            return;
        }
        try {
            this.initialize();
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to initialize " + this.name), (Throwable)e);
        }
    }

    protected boolean testOnline() {
        if (!this.online) {
            this.log.error((Object)("Device " + this.fullName + " is offline"));
        }
        return this.online;
    }

    protected void setOnline(boolean online) {
        if (this.online == online) {
            return;
        }
        this.online = online;
        this.mon.setOnline(this.chanMask, online);
        if (!online) {
            if (!this.disabled) {
                this.log.error((Object)("Disconnected from " + this.fullName));
            }
            this.close();
        }
    }

    protected void readSensors() {
        this.readChannelGroup();
        int id = this.chanMask.nextSetBit(0);
        while (id >= 0) {
            this.mon.getChannel(id).readSensor();
            id = this.chanMask.nextSetBit(id + 1);
        }
    }

    protected void readChannelGroup() {
    }

    protected double readChannel(int hwChan, int type) {
        return Double.NaN;
    }

    protected double readChannelNow(int hwChan, int type) {
        return this.readChannel(hwChan, type);
    }

    protected void checkTimeout(Exception e, Class<?> eClass) throws Exception {
        if (this.isTimeout(e)) {
            this.setOnline(false);
        }
        Constructor<?> eCon = eClass.getConstructor(String.class);
        throw (Exception)eCon.newInstance(e.getMessage());
    }

    protected boolean isTimeout(Exception e) {
        return e.getMessage().matches(".*time.*out.*");
    }

    protected void checkLine(String name, int line) throws Exception {
        this.checkHwLine(name, line);
    }

    protected void checkHwLine(String name, int line) throws Exception {
        MonitorLogUtils.reportError(this.log, name, "device", name);
    }

    protected void setLineWarm(int line, boolean on) {
        this.lineWarm = on ? (this.lineWarm |= 1 << line) : (this.lineWarm &= ~(1 << line));
    }

    protected void setLine(int line, boolean on) {
        this.lineState = on ? (this.lineState |= 1 << line) : (this.lineState &= ~(1 << line));
        this.setHwLine(line, on);
    }

    protected void setHwLine(int line, boolean on) {
    }

    protected boolean isLineSet(int line) {
        return this.isHwLineSet(line);
    }

    protected boolean isHwLineSet(int line) {
        return false;
    }

    protected void setOutputLines() {
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                if ((this.lineWarm & 1 << line) == 0) {
                    this.setLine(line, (this.lineState & 1 << line) != 0);
                } else {
                    this.setLine(line, this.isHwLineSet(line));
                }
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void getOutputLines() {
        this.lineState = 0;
        int mask = this.lineMask;
        int line = 0;
        while (mask != 0) {
            if ((mask & 1) != 0) {
                this.lineState |= this.isHwLineSet(line) ? 1 << line : 0;
            }
            mask >>>= 1;
            ++line;
        }
    }

    protected void addLine(int line) {
        this.lineMask |= 1 << line;
    }

    @Override
    public TreeWalkerDiag checkHardware() throws HardwareException {
        if (!this.disabled) {
            try {
                this.initialize();
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to initialize " + this.name), (Throwable)e);
                throw new HardwareException(false, e);
            }
        }
        return TreeWalkerDiag.GO;
    }
}

