package org.lsst.ccs.subsystem.ccob.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.ccob.constants.CCOBAgentProperties;
import org.lsst.ccs.subsystem.ccob.data.CCOBState;
import org.lsst.ccs.subsystem.ccob.ui.CCOBControlPanel;

/**
 * @author tonyj
 */
@Plugin(name = "CCOB Control Plugin", description = "CCOB Control Plugin")
public class CCOBControlPlugin extends ConsolePlugin {

    @Override
    public void initialize() {
        OptionalPage optPage = new CCOBOptionalPage(CCOBAgentProperties.CCOB_AGENT, CCOBControl.class);
        Console.getConsole().getOptionalPageService().add(optPage);
    }
    
    static class CCOBControl implements Control, StatusMessageListener {

        private CCOBControlPanel ctrlPanel;
        
        @Override
        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals(CCOBState.KEY)) {
                    updateControlPanel(((KeyValueData)sd.getSubsystemData()).getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException x) {
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            ctrlPanel.updateControlPanel((CCOBState)obj);
        }

        @Override
        public void disableSystem() {
            ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            return ctrlPanel = new CCOBControlPanel(sndr);
        }

        @Override
        public void setSubsystems(String name) {
            ctrlPanel.setSubsystem(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
    
}
