/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.ccob.constants.CCOBAgentProperties;
import org.lsst.ccs.subsystem.ccob.data.CCOBState;
import org.lsst.ccs.subsystem.ccob.ui.CCOBControlPanel;
import org.lsst.ccs.subsystem.ccob.ui.jas.CCOBOptionalPage;
import org.lsst.ccs.subsystem.ccob.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.ccob.ui.jas.Control;

@Plugin(name="CCOB Control Plugin", description="CCOB Control Plugin")
public class CCOBControlPlugin
extends ConsolePlugin {
    public void initialize() {
        CCOBOptionalPage optPage = new CCOBOptionalPage(CCOBAgentProperties.CCOB_AGENT, CCOBControl.class);
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class CCOBControl
    implements Control,
    StatusMessageListener {
        private CCOBControlPanel ctrlPanel;

        CCOBControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("CCOBState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateControlPanel((CCOBState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.ctrlPanel = new CCOBControlPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void setSubsystems(String name) {
            this.ctrlPanel.setSubsystem(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

