/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.io.Serializable;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorPageDialog;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;

public class MonitorPage
implements Persistable {
    public static String CATEGORY = "MonitorPage";
    private final Descriptor descriptor;
    private PersistableMonitorView view;
    private JComponent panel;

    public MonitorPage() {
        this.descriptor = new Descriptor();
    }

    public MonitorPage(Descriptor desc) {
        if (desc == null) {
            this.descriptor = new Descriptor();
        } else {
            this.descriptor = desc.clone();
            PersistenceService service = Console.getConsole().getSingleton(PersistenceService.class);
            if (this.descriptor.getView() != null) {
                PersistableAgentChannelsFilter filter;
                this.view = (PersistableMonitorView)service.make(this.descriptor.getView());
                if (this.view != null && this.descriptor.getFilter() != null && (filter = (PersistableAgentChannelsFilter)service.make(this.descriptor.getFilter())) != null) {
                    this.view.setFilter(filter);
                }
            }
        }
    }

    public MonitorPage(PersistableMonitorView view, PersistableAgentChannelsFilter filter, String name) {
        this();
        this.view = view;
        view.setFilter(filter);
        this.descriptor.setName(name);
    }

    @Override
    public MonitorPage edit(String title, Component parent) {
        return MonitorPageDialog.edit(this, title, parent);
    }

    public JComponent getPanel() {
        if (this.panel == null && this.view != null) {
            this.panel = this.view.getPanel();
        }
        return this.panel;
    }

    public PersistableMonitorView getView() {
        return this.view;
    }

    public void setView(PersistableMonitorView view) {
        this.view = view;
        this.panel = null;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.descriptor.clone();
        if (this.view != null) {
            desc.setView(this.view.save());
            AgentChannelsFilter filter = this.view.getFilter();
            if (filter instanceof PersistableAgentChannelsFilter) {
                Serializable d = ((PersistableAgentChannelsFilter)filter).save();
                desc.setFilter((Persistable.Descriptor)d);
            }
        }
        if (this.panel == null) {
            desc.setPanel(null);
        } else {
            desc.setPanel(DataPanelDescriptor.get(this.panel));
        }
        return desc;
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private Persistable.Descriptor view;
        private DataPanelDescriptor panel;
        private Persistable.Descriptor filter;

        public Persistable.Descriptor getView() {
            return this.view;
        }

        public void setView(Persistable.Descriptor view) {
            this.view = view;
        }

        public DataPanelDescriptor getPanel() {
            return this.panel;
        }

        public void setPanel(DataPanelDescriptor panel) {
            this.panel = panel;
        }

        public Persistable.Descriptor getFilter() {
            return this.filter;
        }

        public void setFilter(Persistable.Descriptor filter) {
            this.filter = filter;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.view != null) {
                desc.view = desc.view.clone();
            }
            if (desc.filter != null) {
                desc.filter = desc.filter.clone();
            }
            return desc;
        }
    }
}

