package org.lsst.ccs.subsystem.ccob.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;
import org.lsst.ccs.subsystem.ccob.data.CCOBFullState;
import org.lsst.ccs.subsystem.ccob.data.CCOBState;

/**
 *  Implements the CCOB control panel / monitor panel assembly.
 *
 *  @author Owen Saxton
 */
public class CCOBMonitorAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    CCOBMonitorPanel panel;
    
    public CCOBMonitorAssembly(CCOBMonitorGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
        panel = new CCOBMonitorPanel(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystem(String ccobName) {
        mon.setSubsystems(ccobName);
        panel.setSubsystem(ccobName);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem(id);
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof CCOBFullState) {
            CCOBFullState r = (CCOBFullState)d;
            mon.updateTableModel(name, r.getMonitorFullState());
            panel.updateControlPanel(id, r.getCCOBState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key, Object d) {
        if (key.equals(CCOBState.KEY)) {
            panel.updateControlPanel(id, (CCOBState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
