/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.ccob.data.CCOBState;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class CCOBMonitorPanel
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private String mainName;
    private double mainPeriod = 5.0;
    private JLabel lbMainPeriod;
    private JLabel lbMainPeriodUnits;
    private JLabel lbMainState;
    private JLabel lbMainStateValue;
    private JTextField tfMainPeriod;
    private static final long serialVersionUID = 1L;

    public CCOBMonitorPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.lbMainState.setFont(f);
        this.lbMainStateValue.setFont(f);
        this.lbMainPeriod.setFont(f);
        this.lbMainPeriodUnits.setFont(f);
        new UpdateCCOBStatus(0, new CCOBState(0)).run();
        new DisableSystem(0).run();
    }

    public void setSubsystem(String mainName) {
        this.mainName = mainName;
    }

    private void initComponents() {
        this.lbMainState = new JLabel();
        this.lbMainPeriod = new JLabel();
        this.lbMainStateValue = new JLabel();
        this.tfMainPeriod = new JTextField();
        this.lbMainPeriodUnits = new JLabel();
        this.lbMainState.setText("CCOB State:");
        this.lbMainState.setHorizontalTextPosition(10);
        this.lbMainPeriod.setText("Update Period:");
        this.lbMainStateValue.setText("....");
        this.tfMainPeriod.setText("...");
        this.tfMainPeriod.setMinimumSize(new Dimension(50, 19));
        this.tfMainPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CCOBMonitorPanel.this.tfMainPeriodActionPerformed(evt);
            }
        });
        this.lbMainPeriodUnits.setText("sec");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(255, Short.MAX_VALUE).addComponent(this.lbMainState).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lbMainStateValue, -2, 72, -2).addGap(90, 90, 90).addComponent(this.lbMainPeriod).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfMainPeriod, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbMainPeriodUnits).addContainerGap(244, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbMainStateValue).addComponent(this.lbMainState).addComponent(this.lbMainPeriod, -2, 25, -2).addComponent(this.tfMainPeriod, -2, -1, -2).addComponent(this.lbMainPeriodUnits)).addContainerGap(71, Short.MAX_VALUE)));
    }

    private void tfMainPeriodActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.tfMainPeriod.getText());
            this.gui.sendCommand(this.mainName, null, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.tfMainPeriod.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.tfMainPeriod.setText(String.valueOf(this.mainPeriod));
        }
    }

    public void updateControlPanel(int id, CCOBState rs) {
        SwingUtilities.invokeLater(new UpdateCCOBStatus(id, rs));
    }

    public void disableSystem(int id) {
        SwingUtilities.invokeLater(new DisableSystem(id));
    }

    class DisableSystem
    implements Runnable {
        private final int id;

        DisableSystem(int id) {
            this.id = id;
        }

        @Override
        public void run() {
            if (this.id == 0) {
                CCOBMonitorPanel.this.lbMainStateValue.setText("STOPPED");
                CCOBMonitorPanel.this.lbMainStateValue.setForeground(RED);
                CCOBMonitorPanel.this.tfMainPeriod.setEnabled(false);
            }
        }
    }

    class UpdateCCOBStatus
    implements Runnable {
        private final int id;
        private final CCOBState rs;

        UpdateCCOBStatus(int id, CCOBState rs) {
            this.id = id;
            this.rs = rs;
        }

        @Override
        public void run() {
            if (this.id == 0) {
                CCOBMonitorPanel.this.lbMainStateValue.setText("RUNNING");
                CCOBMonitorPanel.this.lbMainStateValue.setForeground(GREEN);
                CCOBMonitorPanel.this.tfMainPeriod.setEnabled(true);
                CCOBMonitorPanel.this.mainPeriod = (double)this.rs.getTickMillis() / 1000.0;
                CCOBMonitorPanel.this.tfMainPeriod.setText(String.valueOf(CCOBMonitorPanel.this.mainPeriod));
            }
        }
    }
}

