/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ccob.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.ccob.data.CCOBFullState;
import org.lsst.ccs.subsystem.ccob.data.CCOBState;
import org.lsst.ccs.subsystem.ccob.ui.CCOBMonitorGui;
import org.lsst.ccs.subsystem.ccob.ui.CCOBMonitorPanel;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorGui;

public class CCOBMonitorAssembly
extends MonitorGui.Panel {
    MonitorAssembly mon;
    CCOBMonitorPanel panel;
    private static final long serialVersionUID = 1L;

    public CCOBMonitorAssembly(CCOBMonitorGui gui) {
        this.setLayout(new BorderLayout());
        this.mon = new MonitorAssembly((CommandSender)gui);
        this.add((Component)this.mon, "Center");
        this.panel = new CCOBMonitorPanel((CommandSender)gui);
        this.add(this.panel, "South");
    }

    public void setSubsystem(String ccobName) {
        this.mon.setSubsystems(new String[]{ccobName});
        this.panel.setSubsystem(ccobName);
    }

    public void disableSystem(String name, int id) {
        this.panel.disableSystem(id);
        this.mon.disableSystem(name);
    }

    public void updatePanel(String name, int id, Object d) {
        if (d instanceof CCOBFullState) {
            CCOBFullState r = (CCOBFullState)d;
            this.mon.updateTableModel(name, r.getMonitorFullState());
            this.panel.updateControlPanel(id, r.getCCOBState());
        }
    }

    public void handleStatusData(String name, int id, long time, String key, Object d) {
        if (key.equals("CCOBState")) {
            this.panel.updateControlPanel(id, (CCOBState)((KeyValueData)d).getValue());
        } else {
            this.mon.handleData(name, key, d);
        }
    }
}

