/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.freehep.application.Application;
import org.freehep.jas.JAS3;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.openide.util.Lookup;

public class ConsoleApplication
extends JAS3 {
    private final AtomicBoolean exiting = new AtomicBoolean(false);

    public ConsoleApplication() {
        super("CCS_Console");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            try {
                new ConsoleApplication().createFrame(args).setVisible(true);
            }
            catch (HeadlessException x) {
                System.out.println("Fatal Error: " + x.getMessage());
            }
            catch (Throwable t) {
                System.out.println("Fatal Error: " + t.getMessage());
                ConsoleApplication.error(null, (String)"Fatal Error", (Throwable)t);
                System.exit(1);
            }
        });
    }

    public void exit() {
        if (this.exiting.getAndSet(true)) {
            return;
        }
        try {
            ThreadUtil.invokeAndWait(() -> {
                try {
                    Collection plugins = this.getLookup().lookup(new Lookup.Template(ConsolePlugin.class, null, null)).allInstances();
                    plugins.forEach(plugin -> {
                        try {
                            plugin.stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    plugins.forEach(plugin -> {
                        try {
                            plugin.shutdown();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    Console.getConsole().shutdownAgent();
                }
                catch (Throwable t) {
                    System.out.println(t);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        ((Jas3Console)Console.getConsole()).superShutdownAgent();
        super.exit();
    }

    protected Properties createAppProperties() throws Application.InitializationException {
        String appName;
        Properties appProp = super.createAppProperties();
        Properties ccsProp = BootstrapResourceUtils.getBootstrapProperties((String)"gui.properties");
        String prefName = ccsProp.getProperty("org.lsst.ccs.gui.preferences", appName = ccsProp.getProperty("org.lsst.ccs.application.name"));
        if (prefName != null) {
            if (!prefName.endsWith(".properties")) {
                prefName = prefName + ".properties";
            }
            appProp.setProperty("userPrefDir", appProp.getProperty("org.lsst.ccs.gui.home") + "/" + prefName);
        }
        ccsProp.stringPropertyNames().forEach(key -> appProp.setProperty((String)key, ccsProp.getProperty((String)key)));
        return appProp;
    }
}

