package org.lsst.ccs.subsystem.ccob.data;

import java.io.Serializable;

/**
 *  Contains the state of a CCOB subsystem
 *
 *  @author Owen Saxton
 */
public class CCOBState implements Serializable 
{
    
    public static final String KEY = "CCOBState";
    private final int tickMillis;         // Data status update period (ms)
 
    public CCOBState(int tickMillis) {
        this.tickMillis = tickMillis;
    }
    
    public int getTickMillis() {
        return tickMillis;
    }

    @Override
    public String toString() {
        return "tickMillis=" + tickMillis;
    }

    private static final long serialVersionUID = 1180218113615775080L;
}
