package org.lsst.ccs.subsystem.ccob.data;

import java.io.Serializable;
import org.lsst.ccs.subsystem.monitor.data.MonitorFullState;

/**
 *  Contains information describing the full CCOB system state.
 *
 *  Sent on the status bus upon request.
 *
 *  @author Owen Saxton
 */
public class CCOBFullState implements Serializable {

    private final CCOBState ccobState;
    private final MonitorFullState monitorState;

    public CCOBFullState(CCOBState rState, MonitorFullState mState) {
        ccobState = rState;
        monitorState = mState;
    }

    public CCOBState getCCOBState() {
        return ccobState;
    }

    public MonitorFullState getMonitorFullState() {
        return monitorState;
    }

    private static final long serialVersionUID = -6180559152996680800L;
}
