/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.camera.rotator;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.rotator.Position;
import org.lsst.ccs.drivers.rotator.PositionListener;
import org.lsst.ccs.drivers.rotator.RotatorDriver;
import org.lsst.ccs.drivers.rotator.RotatorState;
import org.lsst.ccs.drivers.rotator.RotatorStateChangeListener;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.camera.rotator.RotatorSubsystemPosition;
import org.lsst.ccs.subsystem.camera.rotator.RotatorSubsystemSetState;
import org.lsst.ccs.subsystem.camera.rotator.data.CameraRotatorData;
import org.lsst.ccs.subsystem.camera.rotator.states.CameraRotatorState;

public class CameraRotatorSubsystem
extends Subsystem
implements HasLifecycle,
ConfigurationBulkChangeHandler {
    private static final Logger LOG = Logger.getLogger(CameraRotatorSubsystem.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dictionaryService;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    RotatorSubsystemSetState setState;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    RotatorSubsystemPosition posListen;
    @ConfigurationParameter(description="maximum rotator acceleration", range="0.0..1.0", units="deg/s**2")
    protected volatile double maxAcceleration;
    @ConfigurationParameter(description="maximu rotator velocity", range="0.0..3.5", units="deg/s")
    protected volatile double maxVelocity;
    private final RotatorDriver driver = new RotatorDriver();
    private boolean initialized = false;
    private static final String dataKey = "positionData";
    private CameraRotatorData lastData;

    public CameraRotatorSubsystem() {
        super("camera-rotator", AgentInfo.AgentType.WORKER);
    }

    public void init() {
        this.agentStateService.registerState(CameraRotatorState.class, "State of the camera rotator", (Object)this);
        this.dictionaryService.registerClass(CameraRotatorData.class, dataKey);
        this.writeConfigurableSettings();
        this.initialized = true;
    }

    public void start() {
        this.driver.addStateChangeListener((RotatorStateChangeListener)this.setState);
        this.driver.addPositionListener((PositionListener)this.posListen);
        try {
            this.driver.stop();
        }
        catch (TimeoutException | DriverException ex) {
            throw new RuntimeException(this.name + ": Driver or Timeout Exception on initializing Stop, " + ex);
        }
        this.publishState(CameraRotatorState.STOPPED);
    }

    void publishState(CameraRotatorState state) {
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{state});
        LOG.info(this.name + ": state set to " + state.toString());
    }

    void publishData(Position position) {
        CameraRotatorData data = new CameraRotatorData(position.getPosition(), position.getError());
        this.publishSubsystemDataOnStatusBus(new KeyValueData(dataKey, (Serializable)data));
        this.lastData = data;
    }

    public void validateBulkChange(Map<String, Object> params) {
        Set<String> keys = params.keySet();
    }

    public void setParameterBulk(Map<String, Object> params) {
        Set<String> keys = params.keySet();
        if (keys.contains("maxVelocity")) {
            this.maxVelocity = (Double)params.get("maxVelocity");
        }
        if (keys.contains("maxAcceleration")) {
            this.maxAcceleration = (Double)params.get("maxAcceleration");
        }
        if (this.initialized) {
            this.writeConfigurableSettings();
        }
    }

    boolean isRotating() {
        return this.agentStateService.isInState((Enum)CameraRotatorState.ROTATING);
    }

    private void writeConfigurableSettings() {
        try {
            this.driver.configureVelocity(this.maxVelocity);
            this.driver.configureAcceleration(this.maxAcceleration);
        }
        catch (TimeoutException | DriverException ex) {
            throw new RuntimeException(this.name + ": Driver or Timeout Exception during Configure of EUI:  " + ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, name="rotate", description="Rotate the camera", autoAck=false)
    public void rotate(@Argument(name="position", description="absolute rotator position in degrees") double position) {
        this.helper().precondition(this.agentStateService.isInState((Enum)CameraRotatorState.STOPPED), "Shutter is not stopped", new Object[0]).enterFaultOnException(true).action(() -> {
            Position pos = this.getPosition();
            if (pos != null) {
                LOG.info("Last position as of rotate command: " + pos.toString());
                this.publishData(pos);
            }
            this.driver.move(position);
        });
    }

    @Command(type=Command.CommandType.ACTION, level=0, name="stopRotation", description="Stop the rotator", autoAck=false)
    public void stopRotation() {
        this.helper().enterFaultOnException(true).action(() -> this.driver.stop());
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="getRotatorState", description="return RotatorState")
    public RotatorState getRotatorState() {
        return this.driver.getRotatorState();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showRotatorState", description="return RotatorState as String")
    public String showRotatorState() {
        return this.getRotatorState().toString();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="getPosition", description="get Rotator Position object")
    public Position getPosition() {
        return this.driver.getPosition();
    }

    @Command(type=Command.CommandType.QUERY, level=0, name="showPosition", description="show Rotator position information")
    public String showPosition() {
        return this.getPosition().toString();
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="enable", description="Enable Rotator")
    public void enable() throws DriverException, TimeoutException {
        this.driver.enable();
    }

    @Command(type=Command.CommandType.ACTION, level=1, name="disable", description="Disable Rotator")
    public void disable() throws DriverException, TimeoutException {
        this.driver.disable();
    }
}

