package org.lsst.ccs.subsystem.camera.rotator.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for camera rotator subsystem
 *
 *  @author Al Eisner
 */
public enum CameraRotatorAlerts {

    ROTATOR_FAULT        ("Fault", "Rotator is in fault state"),
    NOT_ENABLED          ("Not Enabled", "Rotator is not enabled");

    private final String id, description;
    
    CameraRotatorAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert() {
        return new Alert(getId(), getDescription());
    }

}
