/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.cablerotator;

import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.cablerotator.Controller;
import org.lsst.ccs.subsystem.motorplatform.bus.AxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.motorplatform.bus.SendAxisStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.SendConfiguration;
import org.lsst.ccs.subsystem.motorplatform.bus.SendControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.ShellCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;

public class Commands
extends Subsystem
implements HasLifecycle,
MotorCommandListener,
ShellCommandListener {
    private static final Logger LOG = Logger.getLogger(Commands.class.getName());
    private static final int COMMAND_TIMEOUT = 30;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private volatile Controller controller;

    public Commands() {
        super("commands", AgentInfo.AgentType.WORKER);
    }

    public void init() {
        DataProviderDictionaryService dictionary = (DataProviderDictionaryService)this.subsys.getAgentService(DataProviderDictionaryService.class);
        dictionary.registerClass(ControllerStatus.class);
        dictionary.registerClass(AxisStatus.class);
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty("motorplatform.type", "CABLE_ROTATOR");
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start an axis homing.", timeout=30)
    public void homeAxis(HomeAxis req) {
        this.controller.homeAxis(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start a move to an absolute position.", timeout=30)
    public void moveAxisAbsolute(MoveAxisAbsolute req) {
        this.controller.moveAxisAbsolute(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Start a position change.", timeout=30)
    public void moveAxisRelative(MoveAxisRelative req) {
        this.controller.moveAxisRelative(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Clear faults on both axes.", timeout=30)
    public void clearAllFaults(ClearAllFaults req) {
        this.controller.clearAllFaults(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Enable/disable axis.", timeout=30)
    public void changeAxisEnable(ChangeAxisEnable req) {
        this.controller.changeAxisEnable(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Clear faults for one axis.", timeout=30)
    public void clearAxisFaults(ClearAxisFaults req) {
        this.controller.clearAxisFaults(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Enable all axes.", timeout=30)
    public void enableAllAxes(EnableAllAxes req) {
        this.controller.enableAllAxes(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Disable all axes.", timeout=30)
    public void disableAllAxes(DisableAllAxes req) {
        this.controller.disableAllAxes(req);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Scripting) Emergency stop motion.", timeout=30)
    public void stopAllMotion(StopAllMotion req) {
        this.controller.stopAllMotion(req);
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish controller status ASAP.", timeout=30)
    public void sendControllerStatus(SendControllerStatus cmd) {
        this.controller.sendControllerStatus(cmd);
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish controller configuration ASAP.", timeout=30)
    public void sendConfiguration(SendConfiguration cmd) {
        this.controller.sendConfiguration(cmd);
    }

    @Command(level=0, type=Command.CommandType.QUERY, description="(Scripting) Publish axis status ASAP.", timeout=30)
    public void sendAxisStatus(SendAxisStatus cmd) {
        this.controller.sendAxisStatus(cmd);
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Clear faults on all axes.", timeout=30)
    public void clearFaults() {
        this.clearAllFaults(new ClearAllFaults());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Emergeny stop motion.", timeout=30)
    public void stopAll() {
        this.stopAllMotion(new StopAllMotion());
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Enable an axis.", timeout=30)
    public void enable(String axisName) {
        this.changeAxisEnable(new ChangeAxisEnable(axisName, true));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Disable an axis.", timeout=30)
    public void disable(String axisName) {
        this.changeAxisEnable(new ChangeAxisEnable(axisName, false));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start an axis homing.", timeout=30)
    public void home(String axisName) {
        this.homeAxis(new HomeAxis(axisName));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start a move to an absolute position.", timeout=30)
    public void moveTo(String axisName, double newPositionMm, double speedMmSec) {
        this.moveAxisAbsolute(new MoveAxisAbsolute(axisName, newPositionMm, speedMmSec));
    }

    @Command(autoAck=false, level=1, type=Command.CommandType.ACTION, description="(Console) Start a position change.", timeout=30)
    public void moveBy(String axisName, double positionChangeMm, double seconds) {
        this.moveAxisRelative(new MoveAxisRelative(axisName, positionChangeMm, Duration.ofMillis((long)Math.rint(seconds * 1000.0))));
    }

    @Command(level=1, type=Command.CommandType.QUERY, description="(Console) Show status info for an axis.", timeout=30)
    public String status(String axisName) {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("Axis %s%n");
        buff.append("Enabled %s, Moving %s,  Is Homed %s, At Low %s, At High %s%n");
        buff.append("Position %6.1f%n");
        AxisStatus axstat = this.controller.getAxisStatus();
        if (axstat == null) {
            return "Not available at present.";
        }
        for (String fault : axstat.getFaults()) {
            buff.append(fault);
            buff.append("%n");
        }
        return String.format(buff.toString(), axstat.getAxisName(), axstat.isEnabled(), axstat.isMoving(), axstat.isAtHome(), axstat.isAtLowLimit(), axstat.isAtHighLimit(), axstat.getPosition());
    }
}

