/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Dimension;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;

@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView", name="Configuration View", path="Built-In/Configuration", description="Monitoring data view that displays configuration state of currently connected subsystems. The view provides controls for saving and resetting configuration, as well as for changing monitoring frequency.")
public class ConfigView
extends AbstractMonitorView1 {
    private final Persistable.Descriptor descriptor = new Persistable.Descriptor();
    private static final String STATE_PATH = "/state/ConfigurationState";
    private static final String TIME_PATH = "/runtimeInfo/current time";
    private List<String> agentList;
    private final AgentDataALL ALL;
    private final TreeMap<String, AgentData> data = new TreeMap();
    private AgentData[] model;
    private final GUI panel;

    public ConfigView() {
        this.ALL = new AgentDataALL();
        this.model = new AgentData[]{this.ALL};
        this.filter = new AbstractChannelsFilter(){

            @Override
            public List<String> getAgents() {
                return ConfigView.this.agentList;
            }

            @Override
            public List<String> getOriginChannels() {
                return Arrays.asList(ConfigView.STATE_PATH, ConfigView.TIME_PATH);
            }
        };
        this.panel = new GUI();
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public AgentChannelsFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        List<String> aa;
        this.agentList = filter == null ? null : ((aa = filter.getAgents()) == null ? null : new ArrayList<String>(aa));
    }

    @Override
    public Persistable.Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected void addChannels(AgentInfo agent, Map<String, AgentChannel> channels) {
        String agentName = agent.getName();
        AgentData ad = this.data.get(agentName);
        if (ad == null) {
            ad = new AgentData();
            this.data.put(agentName, ad);
        }
        for (Map.Entry<String, AgentChannel> e : channels.entrySet()) {
            if (e.getKey().endsWith(STATE_PATH)) {
                ad.configState = e.getValue();
                continue;
            }
            if (!e.getKey().endsWith(TIME_PATH)) continue;
            ad.time = e.getValue();
        }
        this.ALL.time = ad.getTime();
        this.updateModel();
        this.panel.reset();
    }

    @Override
    protected void removeChannels(AgentInfo agent, List<String> paths) {
        String agentName = agent.getName();
        AgentData ad = this.data.remove(agentName);
        this.updateModel();
        if (ad != null) {
            this.panel.reset();
        }
    }

    @Override
    protected void updateChannels(AgentInfo agent, Map<String, Map.Entry<AgentChannel, List<String>>> channels) {
        String agentName = agent.getName();
        AgentData ad = this.data.get(agentName);
        if (ad != null) {
            boolean stateChanged = channels.containsKey(agentName + STATE_PATH);
            if (stateChanged) {
                this.ALL.state = ConfigurationState.CONFIGURED.toString();
                for (int i = 1; i < this.model.length; ++i) {
                    this.ALL.state = this.combineStates(this.ALL.state, this.model[i].getState());
                }
            }
            this.ALL.time = ad.getTime();
            this.panel.update(ad, stateChanged);
        }
    }

    private String combineStates(String state1, String state2) {
        String dirty = ConfigurationState.DIRTY.toString();
        return dirty.equals(state1) || dirty.equals(state2) ? dirty : ConfigurationState.CONFIGURED.toString();
    }

    private void updateModel() {
        this.model = new AgentData[this.data.size() + 1];
        this.model[0] = this.ALL;
        int i = 1;
        for (AgentData item : this.data.values()) {
            this.model[i++] = item;
        }
    }

    private String formatTime(Instant time) {
        try {
            return String.format("%1$tF %1$tT.", ZonedDateTime.ofInstant(time, ZoneId.systemDefault()));
        }
        catch (NullPointerException | DateTimeException | IllegalFormatException x) {
            return "unknown.";
        }
    }

    private class AgentDataALL
    extends AgentData {
        String state;
        Instant time;

        private AgentDataALL() {
            this.state = ConfigurationState.CONFIGURED.toString();
        }

        @Override
        String getName() {
            return "ALL";
        }

        @Override
        Instant getTime() {
            return this.time;
        }

        @Override
        String getState() {
            return this.state;
        }
    }

    private class AgentData {
        AgentChannel configState;
        AgentChannel time;

        private AgentData() {
        }

        String getState() {
            if (this.configState == null) {
                return ConfigurationState.CONFIGURED.toString();
            }
            Object v = this.configState.get();
            return v == null ? ConfigurationState.CONFIGURED.toString() : v.toString();
        }

        Instant getTime() {
            return this.time == null ? null : (Instant)this.time.get();
        }

        String getName() {
            return this.time == null ? this.configState.getAgentName() : this.time.getAgentName();
        }

        public String toString() {
            return ConfigurationState.DIRTY.toString().equals(this.getState()) ? "<html><font color=\"blue\">" + this.getName() : this.getName();
        }
    }

    private final class GUI
    extends JPanel {
        private final JComboBox<AgentData> agentCombo;
        private final JLabel timeLabel;
        private final JButton saveButton;
        private final JButton resetButton;

        GUI() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalGlue());
            Box box = Box.createHorizontalBox();
            this.add(box);
            box.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            this.agentCombo = new JComboBox<AgentData>(ConfigView.this.model);
            this.agentCombo.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.agentCombo.getPreferredSize().height));
            this.agentCombo.addActionListener(e -> {
                AgentData ad = (AgentData)this.agentCombo.getSelectedItem();
                if (ad == null) {
                    return;
                }
                this.onSelection(ad);
            });
            box.add(this.agentCombo);
            box.add(Box.createRigidArea(Const.HDIM));
            box.add(new JLabel("Last updated: "));
            this.timeLabel = new JLabel("Never");
            box.add(this.timeLabel);
            box.add(Box.createRigidArea(new Dimension(30, 5)));
            box.add(Box.createHorizontalGlue());
            this.saveButton = new JButton("Save");
            this.saveButton.addActionListener(e -> {
                AgentData selectedAgent = (AgentData)this.agentCombo.getSelectedItem();
                if (selectedAgent != null && selectedAgent != ConfigView.this.ALL && ConfigurationState.DIRTY.toString().equals(selectedAgent.getState())) {
                    Console.getConsole().sendCommand(selectedAgent.getName() + "/saveAllChanges", new Object[0]);
                }
            });
            box.add(this.saveButton);
            box.add(Box.createRigidArea(Const.HDIM));
            this.resetButton = new JButton("Reset");
            this.resetButton.addActionListener(e -> {
                AgentData selectedAgent = (AgentData)this.agentCombo.getSelectedItem();
                if (selectedAgent != null && selectedAgent != ConfigView.this.ALL && ConfigurationState.DIRTY.toString().equals(selectedAgent.getState())) {
                    Console.getConsole().sendCommand(selectedAgent.getName() + "/dropAllChanges", new Object[0]);
                }
            });
            box.add(this.resetButton);
            box.setMaximumSize(new Dimension(Integer.MAX_VALUE, box.getPreferredSize().height));
            this.add(box);
        }

        void reset() {
            AgentData selected = (AgentData)this.agentCombo.getSelectedItem();
            if (selected == null) {
                selected = ConfigView.this.ALL;
            }
            this.agentCombo.removeAllItems();
            this.agentCombo.setModel(new DefaultComboBoxModel<AgentData>(ConfigView.this.model));
            this.agentCombo.setSelectedItem(selected);
        }

        void update(AgentData item, boolean stateChanged) {
            AgentData selected = (AgentData)this.agentCombo.getSelectedItem();
            if (selected == item || selected == ConfigView.this.ALL) {
                if (stateChanged) {
                    this.onSelection(selected);
                    this.agentCombo.repaint();
                } else {
                    this.timeLabel.setText(ConfigView.this.formatTime(item.getTime()));
                }
            }
        }

        private void onSelection(AgentData item) {
            this.timeLabel.setText(ConfigView.this.formatTime(item.getTime()));
            Boolean b = ConfigurationState.DIRTY.toString().equals(item.getState());
            this.saveButton.setEnabled(b != false && item != ConfigView.this.ALL);
            this.resetButton.setEnabled(b != false && item != ConfigView.this.ALL);
        }
    }
}

