/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.bus;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorReplyCaller;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorReplyListener;

public final class AxisStatus
implements Serializable,
MotorReplyCaller {
    private static final long serialVersionUID = 1L;
    private final String axisName;
    private final boolean enabled;
    private final boolean moving;
    private final boolean atHome;
    private final boolean atLowLimit;
    private final boolean atHighLimit;
    private final List<String> faults;
    private final double position;

    public AxisStatus(String axisName, boolean enabled, boolean moving, boolean atHome, boolean atLowLimit, boolean atHighLimit, List<String> faults, double position) {
        this.axisName = axisName;
        this.enabled = enabled;
        this.moving = moving;
        this.atHome = atHome;
        this.atLowLimit = atLowLimit;
        this.atHighLimit = atHighLimit;
        this.faults = Collections.unmodifiableList(faults);
        this.position = position;
    }

    public String getAxisName() {
        return this.axisName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean isAtHome() {
        return this.atHome;
    }

    public boolean isAtLowLimit() {
        return this.atLowLimit;
    }

    public boolean isAtHighLimit() {
        return this.atHighLimit;
    }

    public List<String> getFaults() {
        return this.faults;
    }

    public double getPosition() {
        return this.position;
    }

    @Override
    public void callMotorReplyHandler(MotorReplyListener motorReplyHandler) {
        motorReplyHandler.axisStatus(this);
    }
}

