/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.Marshaller;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.OneTimeAddressGenerator;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.jgroups.util.Streamable;
import org.jgroups.util.ThreadCreator;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class UPerf
extends ReceiverAdapter {
    private JChannel channel;
    private Address local_addr;
    private RpcDispatcher disp;
    static final String groupname = "uperf";
    protected final List<Address> members = new ArrayList<Address>();
    protected volatile View view;
    protected volatile boolean looping = true;
    protected Thread event_loop_thread;
    protected final LongAdder num_reads = new LongAdder();
    protected final LongAdder num_writes = new LongAdder();
    protected ThreadFactory thread_factory;
    @Property
    protected boolean sync = true;
    @Property
    protected boolean oob = true;
    @Property
    protected int num_threads = 100;
    @Property
    protected int time = 60;
    @Property
    protected int msg_size = 1000;
    @Property
    protected int anycast_count = 2;
    @Property
    protected double read_percentage = 0.8;
    @Property
    protected boolean allow_local_gets = true;
    @Property
    protected boolean print_invokers;
    @Property
    protected boolean print_details;
    private static final Method[] METHODS = new Method[6];
    private static final short START = 0;
    private static final short GET = 1;
    private static final short PUT = 2;
    private static final short GET_CONFIG = 3;
    private static final short SET = 4;
    private static final short QUIT_ALL = 5;
    protected static final Field SYNC;
    protected static final Field OOB;
    protected static final Field NUM_THREADS;
    protected static final Field TIME;
    protected static final Field MSG_SIZE;
    protected static final Field ANYCAST_COUNT;
    protected static final Field READ_PERCENTAGE;
    protected static final Field ALLOW_LOCAL_GETS;
    protected static final Field PRINT_INVOKERS;
    protected static final Field PRINT_DETAILS;
    private final AtomicInteger COUNTER = new AtomicInteger(1);
    private byte[] BUFFER = new byte[this.msg_size];
    protected static final String format = "[1] Start test [2] View [4] Threads (%d) [6] Time (%,ds) [7] Msg size (%s)\n[s] Sync (%b) [o] OOB (%b)\n[a] Anycast count (%d) [r] Read percentage (%.2f) \n[l] local gets (%b) [d] print details (%b)  [i] print invokers (%b)\n[v] Version [x] Exit [X] Exit all\n";

    public void init(String props, String name, AddressGenerator generator, int bind_port, boolean use_fibers) throws Throwable {
        this.thread_factory = new DefaultThreadFactory("invoker", false, true).useFibers(use_fibers);
        if (use_fibers && Util.fibersAvailable()) {
            System.out.println("-- using fibers instead of threads");
        }
        this.channel = new JChannel(props).addAddressGenerator(generator).setName(name);
        if (bind_port > 0) {
            TP transport = this.channel.getProtocolStack().getTransport();
            transport.setBindPort(bind_port);
        }
        this.disp = new RpcDispatcher(this.channel, this).setMembershipListener(this).setMethodLookup(id -> METHODS[id]).setMarshaller(new UPerfMarshaller());
        this.channel.connect(groupname);
        this.local_addr = this.channel.getAddress();
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups", this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel in JMX failed: " + ex);
        }
        if (this.members.size() < 2) {
            return;
        }
        Address coord = this.members.get(0);
        Config config = (Config)this.disp.callRemoteMethod(coord, new MethodCall(3, new Object[0]), new RequestOptions(ResponseMode.GET_ALL, 5000L));
        if (config != null) {
            this.applyConfig(config);
            System.out.println("Fetched config from " + coord + ": " + config + "\n");
        } else {
            System.err.println("failed to fetch config from " + coord);
        }
    }

    void stop() {
        Util.close(this.disp, this.channel);
    }

    protected void startEventThread(boolean use_fibers) {
        this.event_loop_thread = ThreadCreator.createThread(this::eventLoop, "EventLoop", true, use_fibers);
        this.event_loop_thread.start();
    }

    protected void stopEventThread() {
        Thread tmp = this.event_loop_thread;
        this.looping = false;
        if (tmp != null) {
            tmp.interrupt();
        }
        Util.close((Closeable)this.channel);
    }

    @Override
    public void viewAccepted(View new_view) {
        this.view = new_view;
        System.out.println("** view: " + new_view);
        this.members.clear();
        this.members.addAll(new_view.getMembers());
    }

    /*
     * WARNING - void declaration
     */
    public Results startTest() throws Throwable {
        void var11_17;
        this.BUFFER = new byte[this.msg_size];
        System.out.printf("running for %d seconds\n", this.time);
        CountDownLatch latch = new CountDownLatch(1);
        this.num_reads.reset();
        this.num_writes.reset();
        Invoker[] invokers = new Invoker[this.num_threads];
        Thread[] threads = new Thread[this.num_threads];
        for (int i = 0; i < threads.length; ++i) {
            invokers[i] = new Invoker(this.members, latch);
            threads[i] = this.thread_factory.newThread(invokers[i]);
            threads[i].start();
        }
        long start = System.currentTimeMillis();
        latch.countDown();
        long interval = (long)((double)this.time * 1000.0 / 10.0);
        for (int i = 1; i <= 10; ++i) {
            Util.sleep(interval);
            System.out.printf("%d: %s\n", i, this.printAverage(start));
        }
        for (Invoker invoker : invokers) {
            invoker.cancel();
        }
        for (Runnable runnable : threads) {
            ((Thread)runnable).join();
        }
        long total_time = System.currentTimeMillis() - start;
        System.out.println();
        AverageMinMax avg_gets = null;
        Object var11_16 = null;
        for (int i = 0; i < invokers.length; ++i) {
            Invoker invoker = invokers[i];
            if (this.print_invokers) {
                System.out.printf("invoker %s: gets %s puts %s\n", threads[i].getId(), UPerf.print(invoker.avgGets(), this.print_details), UPerf.print(invoker.avgPuts(), this.print_details));
            }
            if (avg_gets == null) {
                avg_gets = invoker.avgGets();
            } else {
                avg_gets.merge(invoker.avgGets());
            }
            if (var11_17 == null) {
                AverageMinMax averageMinMax = invoker.avgPuts();
                continue;
            }
            var11_17.merge(invoker.avgPuts());
        }
        if (this.print_invokers) {
            System.out.printf("\navg over all invokers: gets %s puts %s\n", UPerf.print(avg_gets, this.print_details), UPerf.print((AverageMinMax)var11_17, this.print_details));
        }
        System.out.printf("\ndone (in %s ms)\n", total_time);
        return new Results((int)this.num_reads.sum(), (int)this.num_writes.sum(), total_time, avg_gets, (AverageMinMax)var11_17);
    }

    public void quitAll() {
        System.out.println("-- received quitAll(): shutting down");
        this.stopEventThread();
        System.exit(0);
    }

    protected String printAverage(long start_time) {
        long tmp_time = System.currentTimeMillis() - start_time;
        long reads = this.num_reads.sum();
        long writes = this.num_writes.sum();
        double reqs_sec = (double)(reads + writes) / ((double)tmp_time / 1000.0);
        return String.format("%,.0f reqs/sec (%,d reads %,d writes)", reqs_sec, reads, writes);
    }

    public void set(String field_name, Object value) {
        Field field = Util.getField(this.getClass(), field_name);
        if (field == null) {
            System.err.println("Field " + field_name + " not found");
        } else {
            Util.setField(field, this, value);
            System.out.println(field.getName() + "=" + value);
        }
    }

    public byte[] get(long key) {
        return this.BUFFER;
    }

    public void put(long key, byte[] val) {
    }

    public Config getConfig() {
        Config config = new Config();
        for (Field field : Util.getAllDeclaredFieldsWithAnnotations(UPerf.class, Property.class)) {
            if (!field.isAnnotationPresent(Property.class)) continue;
            config.add(field.getName(), Util.getField(field, this));
        }
        return config;
    }

    protected void applyConfig(Config config) {
        for (Map.Entry<String, Object> entry : config.values.entrySet()) {
            Field field = Util.getField(this.getClass(), entry.getKey());
            Util.setField(field, this, entry.getValue());
        }
    }

    public void eventLoop() {
        while (this.looping) {
            try {
                int c = Util.keyPress(String.format(format, this.num_threads, this.time, Util.printBytes(this.msg_size), this.sync, this.oob, this.anycast_count, this.read_percentage, this.allow_local_gets, this.print_details, this.print_invokers));
                switch (c) {
                    case 49: {
                        this.startBenchmark();
                        break;
                    }
                    case 50: {
                        this.printView();
                        break;
                    }
                    case 52: {
                        this.changeFieldAcrossCluster(NUM_THREADS, Util.readIntFromStdin("Number of sender threads: "));
                        break;
                    }
                    case 54: {
                        this.changeFieldAcrossCluster(TIME, Util.readIntFromStdin("Time (secs): "));
                        break;
                    }
                    case 55: {
                        this.changeFieldAcrossCluster(MSG_SIZE, Util.readIntFromStdin("Message size: "));
                        break;
                    }
                    case 97: {
                        int tmp = this.getAnycastCount();
                        if (tmp < 0) break;
                        this.changeFieldAcrossCluster(ANYCAST_COUNT, tmp);
                        break;
                    }
                    case 111: {
                        this.changeFieldAcrossCluster(OOB, !this.oob);
                        break;
                    }
                    case 115: {
                        this.changeFieldAcrossCluster(SYNC, !this.sync);
                        break;
                    }
                    case 114: {
                        double percentage = UPerf.getReadPercentage();
                        if (!(percentage >= 0.0)) break;
                        this.changeFieldAcrossCluster(READ_PERCENTAGE, percentage);
                        break;
                    }
                    case 100: {
                        this.changeFieldAcrossCluster(PRINT_DETAILS, !this.print_details);
                        break;
                    }
                    case 105: {
                        this.changeFieldAcrossCluster(PRINT_INVOKERS, !this.print_invokers);
                        break;
                    }
                    case 108: {
                        this.changeFieldAcrossCluster(ALLOW_LOCAL_GETS, !this.allow_local_gets);
                        break;
                    }
                    case 118: {
                        System.out.printf("Version: %s\n", Version.printVersion());
                        break;
                    }
                    case -1: 
                    case 120: {
                        this.looping = false;
                        break;
                    }
                    case 88: {
                        try {
                            RequestOptions options = new RequestOptions(ResponseMode.GET_NONE, 0L).flags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
                            this.disp.callRemoteMethods(null, new MethodCall(5, new Object[0]), options);
                        }
                        catch (Throwable t) {
                            System.err.println("Calling quitAll() failed: " + t);
                        }
                        break;
                    }
                    case 10: 
                    case 13: {
                        break;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.stop();
    }

    void startBenchmark() {
        RspList responses = null;
        try {
            RequestOptions options = new RequestOptions(ResponseMode.GET_ALL, 0L);
            options.flags(Message.Flag.OOB, Message.Flag.DONT_BUNDLE, Message.Flag.NO_FC);
            responses = this.disp.callRemoteMethods(null, new MethodCall(0, new Object[0]), options);
        }
        catch (Throwable t) {
            System.err.println("starting the benchmark failed: " + t);
            return;
        }
        long total_reqs = 0L;
        long total_time = 0L;
        AverageMinMax avg_gets = null;
        AverageMinMax avg_puts = null;
        System.out.println("\n======================= Results: ===========================");
        for (Map.Entry entry : responses.entrySet()) {
            Address mbr = (Address)entry.getKey();
            Rsp rsp = (Rsp)entry.getValue();
            Results result = (Results)rsp.getValue();
            if (result != null) {
                total_reqs += result.num_gets + result.num_puts;
                total_time += result.time;
                if (avg_gets == null) {
                    avg_gets = result.avg_gets;
                } else {
                    avg_gets.merge(result.avg_gets);
                }
                if (avg_puts == null) {
                    avg_puts = result.avg_puts;
                } else {
                    avg_puts.merge(result.avg_puts);
                }
            }
            System.out.println(mbr + ": " + result);
        }
        double total_reqs_sec = (double)total_reqs / ((double)total_time / 1000.0);
        double throughput = total_reqs_sec * (double)this.BUFFER.length;
        System.out.println("\n");
        System.out.println(Util.bold(String.format("Throughput: %,.2f reqs/sec/node (%s/sec)\nRoundtrip:  gets %s, puts %s\n", total_reqs_sec, Util.printBytes(throughput), UPerf.print(avg_gets, this.print_details), UPerf.print(avg_puts, this.print_details))));
        System.out.println("\n\n");
    }

    static double getReadPercentage() throws Exception {
        double tmp = Util.readDoubleFromStdin("Read percentage: ");
        if (tmp < 0.0 || tmp > 1.0) {
            System.err.println("read percentage must be >= 0 or <= 1.0");
            return -1.0;
        }
        return tmp;
    }

    int getAnycastCount() throws Exception {
        View tmp_view;
        int tmp = Util.readIntFromStdin("Anycast count: ");
        if (tmp > (tmp_view = this.channel.getView()).size()) {
            System.err.println("anycast count must be smaller or equal to the view size (" + tmp_view + ")\n");
            return -1;
        }
        return tmp;
    }

    protected void changeFieldAcrossCluster(Field field, Object value) throws Exception {
        this.disp.callRemoteMethods(null, new MethodCall(4, field.getName(), value), RequestOptions.SYNC());
    }

    protected void printView() {
        System.out.printf("\n-- local: %s, view: %s\n", this.local_addr, this.view);
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String print(AverageMinMax avg, boolean details) {
        return details ? String.format("min/avg/max = %,.2f/%,.2f/%,.2f us", (double)avg.min() / 1000.0, avg.average() / 1000.0, (double)avg.max() / 1000.0) : String.format("avg = %,.2f us", avg.average() / 1000.0);
    }

    protected static List<String> getSites(JChannel channel) {
        RELAY2 relay = (RELAY2)channel.getProtocolStack().findProtocol((Class<? extends Protocol>)RELAY2.class);
        return relay != null ? relay.siteNames() : new ArrayList(0);
    }

    private Address getReceiver() {
        try {
            List<Address> mbrs = this.channel.getView().getMembers();
            int index = mbrs.indexOf(this.local_addr);
            int new_index = index + 1 % mbrs.size();
            return mbrs.get(new_index);
        }
        catch (Exception e) {
            System.err.println("UPerf.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        block10: {
            String props = null;
            String name = null;
            boolean run_event_loop = true;
            boolean use_fibers = true;
            OneTimeAddressGenerator addr_generator = null;
            int port = 0;
            for (int i = 0; i < args.length; ++i) {
                if ("-props".equals(args[i])) {
                    props = args[++i];
                    continue;
                }
                if ("-name".equals(args[i])) {
                    name = args[++i];
                    continue;
                }
                if ("-nohup".equals(args[i])) {
                    run_event_loop = false;
                    continue;
                }
                if ("-uuid".equals(args[i])) {
                    addr_generator = new OneTimeAddressGenerator(Long.parseLong(args[++i]));
                    continue;
                }
                if ("-port".equals(args[i])) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-use_fibers".equals(args[i])) {
                    use_fibers = Boolean.parseBoolean(args[++i]);
                    continue;
                }
                UPerf.help();
                return;
            }
            UPerf test = null;
            try {
                test = new UPerf();
                test.init(props, name, addr_generator, port, use_fibers);
                if (run_event_loop) {
                    test.startEventThread(use_fibers);
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (test == null) break block10;
                test.stop();
            }
        }
    }

    static void help() {
        System.out.println("UPerf [-props <props>] [-name name] [-nohup] [-uuid <UUID>] [-port <bind port>] [-use_fibers <true|false>]");
    }

    static {
        try {
            UPerf.METHODS[0] = UPerf.class.getMethod("startTest", new Class[0]);
            UPerf.METHODS[1] = UPerf.class.getMethod("get", Long.TYPE);
            UPerf.METHODS[2] = UPerf.class.getMethod("put", Long.TYPE, byte[].class);
            UPerf.METHODS[3] = UPerf.class.getMethod("getConfig", new Class[0]);
            UPerf.METHODS[4] = UPerf.class.getMethod("set", String.class, Object.class);
            UPerf.METHODS[5] = UPerf.class.getMethod("quitAll", new Class[0]);
            ClassConfigurator.add((short)11000, Results.class);
            SYNC = Util.getField(UPerf.class, "sync", true);
            OOB = Util.getField(UPerf.class, "oob", true);
            NUM_THREADS = Util.getField(UPerf.class, "num_threads", true);
            TIME = Util.getField(UPerf.class, "time", true);
            MSG_SIZE = Util.getField(UPerf.class, "msg_size", true);
            ANYCAST_COUNT = Util.getField(UPerf.class, "anycast_count", true);
            READ_PERCENTAGE = Util.getField(UPerf.class, "read_percentage", true);
            ALLOW_LOCAL_GETS = Util.getField(UPerf.class, "allow_local_gets", true);
            PRINT_INVOKERS = Util.getField(UPerf.class, "print_invokers", true);
            PRINT_DETAILS = Util.getField(UPerf.class, "print_details", true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected class UPerfMarshaller
    implements Marshaller {
        protected UPerfMarshaller() {
        }

        @Override
        public int estimatedSize(Object arg) {
            if (arg == null) {
                return 2;
            }
            if (arg instanceof byte[]) {
                return UPerf.this.msg_size + 24;
            }
            if (arg instanceof Long) {
                return 10;
            }
            return 50;
        }

        @Override
        public void objectToStream(Object obj, DataOutput out) throws IOException {
            Util.objectToStream(obj, out);
        }

        @Override
        public Object objectFromStream(DataInput in) throws IOException, ClassNotFoundException {
            return Util.objectFromStream(in);
        }
    }

    public static class Config
    implements Streamable {
        protected Map<String, Object> values = new HashMap<String, Object>();

        public Config add(String key, Object value) {
            this.values.put(key, value);
            return this;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeInt(this.values.size());
            for (Map.Entry<String, Object> entry : this.values.entrySet()) {
                Bits.writeString(entry.getKey(), out);
                Util.objectToStream(entry.getValue(), out);
            }
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                String key = Bits.readString(in);
                Object value = Util.objectFromStream(in);
                if (key == null) continue;
                this.values.put(key, value);
            }
        }

        public String toString() {
            return this.values.toString();
        }
    }

    private class Invoker
    implements Runnable {
        private final List<Address> dests = new ArrayList<Address>();
        private final CountDownLatch latch;
        private final AverageMinMax avg_gets = new AverageMinMax();
        private final AverageMinMax avg_puts = new AverageMinMax();
        private final List<Address> targets;
        private volatile boolean running;

        public Invoker(Collection<Address> dests, CountDownLatch latch) {
            this.targets = new ArrayList<Address>(UPerf.this.anycast_count);
            this.running = true;
            this.latch = latch;
            this.dests.addAll(dests);
        }

        public AverageMinMax avgGets() {
            return this.avg_gets;
        }

        public AverageMinMax avgPuts() {
            return this.avg_puts;
        }

        public void cancel() {
            this.running = false;
        }

        @Override
        public void run() {
            Object[] put_args = new Object[]{0, UPerf.this.BUFFER};
            Object[] get_args = new Object[]{0};
            MethodCall get_call = new MethodCall(1, get_args);
            MethodCall put_call = new MethodCall(2, put_args);
            RequestOptions get_options = new RequestOptions(ResponseMode.GET_ALL, 40000L, false, null);
            RequestOptions put_options = new RequestOptions(UPerf.this.sync ? ResponseMode.GET_ALL : ResponseMode.GET_NONE, 40000L, true, null);
            if (UPerf.this.oob) {
                get_options.flags(Message.Flag.OOB);
                put_options.flags(Message.Flag.OOB);
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.running) {
                boolean get = Util.tossWeightedCoin(UPerf.this.read_percentage);
                try {
                    if (get) {
                        Address target = this.pickTarget();
                        long start = System.nanoTime();
                        if (UPerf.this.allow_local_gets && Objects.equals(target, UPerf.this.local_addr)) {
                            UPerf.this.get(1L);
                        } else {
                            UPerf.this.disp.callRemoteMethod(target, get_call, get_options);
                        }
                        long get_time = System.nanoTime() - start;
                        this.avg_gets.add(get_time);
                        UPerf.this.num_reads.increment();
                        continue;
                    }
                    this.pickAnycastTargets(this.targets);
                    long start = System.nanoTime();
                    UPerf.this.disp.callRemoteMethods(this.targets, put_call, put_options);
                    long put_time = System.nanoTime() - start;
                    this.avg_puts.add(put_time);
                    UPerf.this.num_writes.increment();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        private Address pickTarget() {
            return Util.pickRandomElement(this.dests);
        }

        private void pickAnycastTargets(List<Address> anycast_targets) {
            int index = this.dests.indexOf(UPerf.this.local_addr);
            for (int i = index + 1; i < index + 1 + UPerf.this.anycast_count; ++i) {
                int new_index = i % this.dests.size();
                Address tmp = this.dests.get(new_index);
                if (anycast_targets.contains(tmp)) continue;
                anycast_targets.add(tmp);
            }
        }
    }

    public static class Results
    implements Streamable {
        protected long num_gets;
        protected long num_puts;
        protected long time;
        protected AverageMinMax avg_gets;
        protected AverageMinMax avg_puts;

        public Results() {
        }

        public Results(int num_gets, int num_puts, long time, AverageMinMax avg_gets, AverageMinMax avg_puts) {
            this.num_gets = num_gets;
            this.num_puts = num_puts;
            this.time = time;
            this.avg_gets = avg_gets;
            this.avg_puts = avg_puts;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeLong(this.num_gets, out);
            Bits.writeLong(this.num_puts, out);
            Bits.writeLong(this.time, out);
            Util.writeStreamable(this.avg_gets, out);
            Util.writeStreamable(this.avg_puts, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.num_gets = Bits.readLong(in);
            this.num_puts = Bits.readLong(in);
            this.time = Bits.readLong(in);
            this.avg_gets = Util.readStreamable(AverageMinMax::new, in);
            this.avg_puts = Util.readStreamable(AverageMinMax::new, in);
        }

        public String toString() {
            long total_reqs = this.num_gets + this.num_puts;
            double total_reqs_per_sec = (double)total_reqs / ((double)this.time / 1000.0);
            return String.format("%,.2f reqs/sec (%,d gets, %,d puts, get RTT %,.2f us, put RTT %,.2f us)", total_reqs_per_sec, this.num_gets, this.num_puts, this.avg_gets.average() / 1000.0, this.avg_puts.getAverage() / 1000.0);
        }
    }
}

