/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.commons.annotations.scanner.FieldAnnotationScanner;
import org.lsst.ccs.commons.annotations.scanner.ReflectObject;
import org.lsst.ccs.config.RemoteFileServer;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;

public final class PersistencyService
implements ServiceLifecycle,
HasLifecycle {
    private static final Logger log = Logger.getLogger(PersistencyService.class.getName());
    private String persistencyFileName = "<description>_<site>_<cluster>_<alias>.properties";
    private boolean canSetPersistencyFileName = true;
    private final PersistencyDAO persistencyDAO;
    private final Map<String, ObjectPersistensyService> objectMap = new HashMap<String, ObjectPersistensyService>();
    private boolean loadAtStartup = false;
    private boolean persistAtShutdown = false;
    private boolean hasBeenInitialized = false;

    private PersistencyService(Agent a) {
        Properties p = BootstrapResourceUtils.getBootstrapSystemProperties();
        String daoType = p.getProperty("org.lsst.ccs.persist.remote", "");
        if (daoType.isEmpty()) {
            daoType = p.getProperty("org.lsst.ccs.remote", "false");
        }
        this.persistencyDAO = daoType.equals("true") ? new RemotePersistencyDAO(a.getDescription()) : (daoType.equals("migrate") ? new MigratePersistencyDAO(a.getDescription()) : new FileBasedPersistencyDAO());
    }

    static PersistencyService create(Agent a) {
        PersistencyService sps = new PersistencyService(a);
        FieldAnnotationScanner fas = new FieldAnnotationScanner(Persist.class);
        ComponentLookup lookup = a.getComponentLookup();
        TreeWalkerUtils.proceduralBiWalk(lookup, null, Object.class, (n, o) -> {
            ReflectObject so = fas.scan(o);
            if (so != null) {
                ObjectPersistensyService ops = new ObjectPersistensyService(o);
                ops.fields.putAll(so.getFields());
                sps.objectMap.put(n.getKey(), ops);
            }
        }, null);
        if (sps.objectMap.isEmpty()) {
            return null;
        }
        ArrayList<String> missingVolatile = new ArrayList<String>();
        for (Map.Entry<String, ObjectPersistensyService> objEntry : sps.objectMap.entrySet()) {
            ObjectPersistensyService obj = objEntry.getValue();
            for (Map.Entry field : obj.fields.entrySet()) {
                Field f = (Field)field.getValue();
                boolean isVolatileOrFinal = Modifier.isVolatile(f.getModifiers()) || Modifier.isFinal(f.getModifiers());
                if (isVolatileOrFinal) continue;
                missingVolatile.add(lookup.getComponentNodeForObject(obj.target).getPath() + "/" + f.getName());
            }
        }
        if (missingVolatile.size() > 0) {
            log.log(Level.WARNING, "Fields annotated with Persist must be declared as \"volatile\".\nPlease update your code for the following parameters:\n{0}", missingVolatile);
        }
        lookup.addComponentNodeToLookup(lookup.getTopComponentNode(), new ComponentNode("persistencyService", (Object)sps));
        return sps;
    }

    @Override
    public void afterInit() {
        this.canSetPersistencyFileName = false;
        this.persistencyFileName = SubstitutionTokenUtils.resolveSubstitutionTokens((String)this.persistencyFileName);
        if (!this.persistencyFileName.startsWith("persistence_")) {
            this.persistencyFileName = "persistence_" + this.persistencyFileName;
        }
    }

    public void setPersistencyFileName(String fileName) {
        if (!this.canSetPersistencyFileName) {
            throw new RuntimeException("It's too late to change the persistency file name. It must be done before the end of the HasLifecycle::init phase.");
        }
        this.persistencyFileName = fileName;
    }

    @Override
    public void preStart() {
        this.hasBeenInitialized = true;
        if (this.loadAtStartup || this.persistencyDAO instanceof MigratePersistencyDAO) {
            this.load();
        }
        if (this.persistencyDAO instanceof MigratePersistencyDAO) {
            System.exit(0);
        }
    }

    @Override
    public void preShutdown() {
        if (this.persistAtShutdown) {
            this.persistNow();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.persistencyDAO.close();
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Problems closing the persistency DAO", ioe);
        }
    }

    public void setAutomatic(boolean loadAtStartup, boolean persistAtShutdown) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("this method can only be called at the intialization step");
        }
        this.loadAtStartup = loadAtStartup;
        this.persistAtShutdown = persistAtShutdown;
    }

    @Command(description="writes persistent data in local file", category=Command.CommandCategory.SYSTEM)
    public boolean persistNow() {
        Properties dataToSave = new Properties();
        for (Map.Entry<String, ObjectPersistensyService> objEntry : this.objectMap.entrySet()) {
            ObjectPersistensyService obj = objEntry.getValue();
            for (Map.Entry field : obj.fields.entrySet()) {
                Field f = (Field)field.getValue();
                try {
                    f.setAccessible(true);
                    Object val = f.get(obj.target);
                    f.setAccessible(false);
                    String strVal = TypeUtils.stringify((Object)val);
                    dataToSave.put(objEntry.getKey() + "/" + (String)field.getKey(), strVal);
                }
                catch (IllegalAccessException ex) {
                    log.log(Level.SEVERE, "cannot persist field : " + objEntry.getKey() + "/" + (String)field.getKey() + " : aborting", ex);
                    return false;
                }
            }
        }
        log.log(Level.INFO, "Persisting to {0}: \n{1}", new Object[]{this.persistencyDAO.getFileName(this.persistencyFileName), dataToSave});
        return this.persistencyDAO.savePersistencyData(this.persistencyFileName, dataToSave);
    }

    @Command(description="loads persistent data from local file", category=Command.CommandCategory.SYSTEM)
    public boolean load() {
        Properties props = this.getPersistenceProperties();
        log.log(Level.INFO, "Loading {0}:\n{1}", new Object[]{this.persistencyDAO.getFileName(this.persistencyFileName), props});
        if (props == null) {
            return false;
        }
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            Field f;
            String name = (String)prop.getKey();
            String val = (String)prop.getValue();
            ParameterPath pp = ParameterPath.valueOf((String)name);
            ObjectPersistensyService ops = this.objectMap.get(pp.getComponentName());
            if (ops == null || (f = (Field)ops.fields.get(pp.getParameterName())) == null) continue;
            Object objVal = InputConversionEngine.convertArgToType((String)val, (Type)f.getGenericType());
            try {
                f.setAccessible(true);
                this.reconstructObject(ops.target, objVal, f);
                f.setAccessible(false);
            }
            catch (IllegalAccessException | RuntimeException ex) {
                log.log(Level.SEVERE, "cannot set " + pp, ex);
                return false;
            }
        }
        return true;
    }

    private Properties getPersistenceProperties() {
        Properties res = null;
        try {
            res = this.persistencyDAO.loadPersistencyData(this.persistencyFileName);
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, "could not open persisted data file " + this.persistencyFileName, ex);
        }
        return res;
    }

    @Command(description="returns true if a local persistence file is present, false otherwise.", category=Command.CommandCategory.SYSTEM)
    public boolean isLocalPersistenceFilePresent() {
        return this.getPersistenceProperties() != null;
    }

    private void reconstructObject(Object target, Object objVal, Field field) throws IllegalAccessException, RuntimeException {
        Object fieldObject = field.get(target);
        if (fieldObject.getClass().isInstance(objVal)) {
            field.set(target, objVal);
        } else if (fieldObject instanceof Map) {
            Map existingMap = (Map)fieldObject;
            existingMap.clear();
            existingMap.putAll((Map)objVal);
        } else if (fieldObject instanceof List) {
            List existingList = (List)fieldObject;
            existingList.clear();
            existingList.addAll((List)objVal);
        } else if (fieldObject instanceof Set) {
            Set existingSet = (Set)fieldObject;
            existingSet.clear();
            existingSet.addAll((Set)objVal);
        } else {
            throw new RuntimeException("Failed to custom fill field " + field.getName() + " of type " + fieldObject.getClass());
        }
    }

    private class RemotePersistencyDAO
    implements PersistencyDAO {
        private final RemoteFileServer remoteFileServer;

        RemotePersistencyDAO(String descName) {
            Properties p = new Properties();
            String uri = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.remote.server.uri.persistence", "");
            if (!uri.isEmpty()) {
                p.setProperty("org.lsst.ccs.remote.server.uri", uri);
            }
            this.remoteFileServer = new RemoteFileServer(descName, "persistence", p);
        }

        @Override
        public Properties loadPersistencyData(String fileName) throws IOException {
            Properties p = new Properties();
            try (InputStream is = this.remoteFileServer.getInputStream(this.pathFromFileName(fileName), new OpenOption[]{StandardOpenOption.CREATE});){
                if (is != null) {
                    p.load(is);
                }
            }
            return p;
        }

        @Override
        public Writer getWriter(String fileName) throws IOException {
            return this.remoteFileServer.getBufferedWriter(this.pathFromFileName(fileName), new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING});
        }

        @Override
        public void close() throws IOException {
            this.remoteFileServer.close();
        }

        private Path pathFromFileName(String fileName) {
            String[] split = fileName.replace("persistence_", "").split("_");
            ArrayList<String> args = new ArrayList<String>();
            for (int i = 1; i < split.length; ++i) {
                args.add(split[i]);
            }
            return this.remoteFileServer.getFileSystem().getPath(split[0], args.toArray(new String[0]));
        }

        @Override
        public String getFileName(String fileName) {
            return this.pathFromFileName(fileName).toAbsolutePath().toString();
        }
    }

    private class MigratePersistencyDAO
    implements PersistencyDAO {
        private final RemotePersistencyDAO remoteDAO;
        private final FileBasedPersistencyDAO localDAO;

        MigratePersistencyDAO(String cacheName) {
            this.remoteDAO = new RemotePersistencyDAO(cacheName);
            this.localDAO = new FileBasedPersistencyDAO();
        }

        @Override
        public Properties loadPersistencyData(String fileName) throws IOException {
            Properties p = this.localDAO.loadPersistencyData(fileName);
            this.remoteDAO.savePersistencyData(PersistencyService.this.persistencyFileName, p);
            return p;
        }

        @Override
        public Writer getWriter(String fileName) throws IOException {
            throw new RuntimeException("This method should not have been invoked");
        }

        @Override
        public void close() throws IOException {
            this.remoteDAO.close();
            this.localDAO.close();
        }

        @Override
        public boolean savePersistencyData(String persistencyFileName, Properties data) {
            return false;
        }

        @Override
        public String getFileName(String fileName) {
            return fileName;
        }
    }

    private class FileBasedPersistencyDAO
    implements PersistencyDAO {
        private final WriterProvider wp = WriterProvider.getInstance();

        @Override
        public Writer getWriter(String fileName) throws IOException {
            return this.wp.getPrintWriter(fileName);
        }

        @Override
        public Properties loadPersistencyData(String fileName) throws IOException {
            return this.wp.getProperties(fileName);
        }

        @Override
        public String getFileName(String fileName) {
            return fileName;
        }
    }

    static interface PersistencyDAO
    extends Closeable {
        public Properties loadPersistencyData(String var1) throws IOException;

        public Writer getWriter(String var1) throws IOException;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        default public boolean savePersistencyData(String persistencyFileName, Properties data) {
            try {
                Writer printWriter = this.getWriter(persistencyFileName);
                try {
                    for (String key : data.stringPropertyNames()) {
                        String strVal = data.getProperty(key);
                        try {
                            printWriter.write(key + " = " + strVal + "\n");
                        }
                        catch (IOException ex) {
                            log.log(Level.SEVERE, "cannot persist field : " + key + strVal + " : aborting", ex);
                            boolean bl = false;
                            if (printWriter == null) return bl;
                            printWriter.close();
                            return bl;
                        }
                    }
                    printWriter.flush();
                }
                finally {
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "cannot open persistence file", ioe);
                return false;
            }
            if (!(this instanceof RemotePersistencyDAO)) return true;
            try {
                this.loadPersistencyData(persistencyFileName);
                return true;
            }
            catch (IOException ioe) {
                log.log(Level.SEVERE, "Failed to reload " + persistencyFileName, ioe);
            }
            return true;
        }

        @Override
        default public void close() throws IOException {
        }

        public String getFileName(String var1);
    }

    private static class ObjectPersistensyService {
        private final Object target;
        private final Map<String, Field> fields = new HashMap<String, Field>();

        private ObjectPersistensyService(Object obj) {
            this.target = obj;
        }
    }
}

