/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mks;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Multidrop;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mks.Model9XX;

public class Test9XX {
    private final Model9XX[] devs = new Model9XX[]{new Model9XX(), new Model9XX(), new Model9XX(), new Model9XX(), new Model9XX()};
    private Model9XX dev = this.devs[0];
    private int devNumber = 0;

    @Command(description="Set the current device number")
    public void setDeviceNum(@Argument(description="The device number") int number) throws DriverException {
        if (number < 0 || number >= this.devs.length) {
            throw new DriverException("Invalid device number");
        }
        this.devNumber = number;
        this.dev = this.devs[this.devNumber];
    }

    @Command(description="Show the current device number")
    public int showDeviceNum() {
        return this.devNumber;
    }

    @Command(description="Open connection to device")
    public void open(@Argument(description="Connection type") Multidrop.ConnType type, @Argument(description="Identification") String ident) throws DriverException {
        this.dev.open(type, ident, -1);
    }

    @Command(description="Open connection to device")
    public void open(@Argument(description="Connection type") Multidrop.ConnType type, @Argument(description="Identification") String ident, @Argument(description="Device address") int addr) throws DriverException {
        this.dev.open(type, ident, addr);
    }

    @Command(description="Open connection to device")
    public void open(@Argument(description="Connection type") Multidrop.ConnType type, @Argument(description="Identification") String ident, @Argument(description="Baud rate") int baud, @Argument(description="Device address") int addr) throws DriverException {
        this.dev.open(type, ident, baud, addr);
    }

    @Command(description="Close the connection")
    public void close() throws DriverException {
        this.dev.close();
    }

    @Command(description="Write a command")
    public void write(@Argument(description="Command") String cmnd) throws DriverException {
        this.dev.writeCmnd(cmnd);
    }

    @Command(description="Read response from a command")
    public String read(@Argument(description="Command") String cmnd) throws DriverException {
        return this.dev.readString(cmnd);
    }

    @Command(description="Set protected settings lock")
    public void setLock(@Argument(description="ON or OFF") OnOff onoff) throws DriverException {
        this.dev.setLock(onoff == OnOff.ON);
    }

    @Command(description="Set factory defaults")
    public void setDefaults() throws DriverException {
        this.dev.setDefaults();
    }

    @Command(description="Set factory defaults")
    public void setDefaults(@Argument(description="Default item to set") Model9XX.Default item) throws DriverException {
        this.dev.setDefaults(item);
    }

    @Command(description="Show device type")
    public String showDeviceType() throws DriverException {
        return this.dev.getDeviceType();
    }

    @Command(description="Show firmware version")
    public String showFwVersion() throws DriverException {
        return this.dev.getFirmwareVersion();
    }

    @Command(description="Show hardware version")
    public String showHwVersion() throws DriverException {
        return this.dev.getHardwareVersion();
    }

    @Command(description="Show manufacturer")
    public String showManufacturer() throws DriverException {
        return this.dev.getManufacturer();
    }

    @Command(description="Show model")
    public String showModel() throws DriverException {
        return this.dev.getModel();
    }

    @Command(description="Show part number")
    public String showPart() throws DriverException {
        return this.dev.getPartNumber();
    }

    @Command(description="Show serial number")
    public String showSerial() throws DriverException {
        return this.dev.getSerialNumber();
    }

    @Command(description="Set user tag")
    public void setUserTag(@Argument(description="The tag string") String tag) throws DriverException {
        this.dev.setUserTag(tag);
    }

    @Command(description="Show user tag")
    public String showUserTag() throws DriverException {
        return this.dev.getUserTag();
    }

    @Command(description="Show transducer status string")
    public String showTransStatus() throws DriverException {
        return this.dev.getTransStatus();
    }

    @Command(description="Show transducer status word")
    public char showStatus() throws DriverException {
        return this.dev.getStatus();
    }

    @Command(description="Show unit on time")
    public String showOnTime() throws DriverException {
        return this.dev.getTimeOn() + " hours";
    }

    @Command(description="Show cold cathode on time")
    public String showSensorTime() throws DriverException {
        return this.dev.getSensorTimeOn() + " hours";
    }

    @Command(description="Show cold cathose pressure dose")
    public String showSensorDose() throws DriverException {
        return this.dev.getSensorDose() + " " + this.getUnitsString() + " hours";
    }

    @Command(description="Set cold cathode dose limit")
    public void setDoseLimit(@Argument(description="Dose limit (press-unit hours)") double dose) throws DriverException {
        this.dev.setSensorDoseLimit(dose);
    }

    @Command(description="Show cold cathode dose limit")
    public String showDoseLimit() throws DriverException {
        return this.dev.getSensorDoseLimit() + " " + this.getUnitsString() + " hours";
    }

    @Command(description="Set pressure units")
    public void setUnits(@Argument(description="Pressure units") Model9XX.Unit units) throws DriverException {
        this.dev.setPressureUnit(units);
    }

    @Command(description="Show pressure units")
    public Model9XX.Unit showUnits() throws DriverException {
        return this.dev.getPressureUnit();
    }

    @Command(description="Set calibration gas type")
    public void setGasType(@Argument(description="Gas type") Model9XX.Gas gas) throws DriverException {
        this.dev.setCalibrationGas(gas);
    }

    @Command(description="Show calibration gas type")
    public Model9XX.Gas showGasType() throws DriverException {
        return this.dev.getCalibrationGas();
    }

    @Command(description="Read vacuum pressure")
    public String readPressure() throws DriverException {
        return this.dev.readPressure() + " " + this.getUnitsString();
    }

    @Command(description="Read vacuum pressure")
    public String readPressure(@Argument(description="Sensor to use") Model9XX.Sensor sensor) throws DriverException {
        return this.dev.readPressure(sensor) + " " + this.getUnitsString();
    }

    @Command(description="Set atmospheric pressure")
    public void setAtmospheric(@Argument(description="Atmospheric pressure") double press) throws DriverException {
        this.dev.calibrateAtmospheric(press);
    }

    @Command(description="Show atmospheric pressure difference")
    public String showAtmospheric() throws DriverException {
        return this.dev.getAtmospheric() + " " + this.getUnitsString();
    }

    @Command(description="Set full-scale pressure")
    public void setFullScale(@Argument(description="Pressure") double press) throws DriverException {
        this.dev.calibrateFullScale(press);
    }

    @Command(description="Show full-scale pressure difference")
    public String showFullScale() throws DriverException {
        return this.dev.getFullScale() + " " + this.getUnitsString();
    }

    @Command(description="Read MicroPirani temperature")
    public String readTemperature() throws DriverException {
        return this.dev.readTemperature() + " C";
    }

    @Command(description="Set relay trip point")
    public void setRelayTrip(@Argument(description="Relay number") int relay, @Argument(description="Trip point value") double value) throws DriverException {
        this.dev.setRelayTrip(relay, value);
    }

    @Command(description="Show relay trip point")
    public String showRelayTrip(@Argument(description="Relay number") int relay) throws DriverException {
        return this.dev.getRelayTrip(relay) + " " + this.getUnitsString();
    }

    @Command(description="Set relay hysteresis")
    public void setRelayHyst(@Argument(description="Relay number") int relay, @Argument(description="Hysteresis value") double value) throws DriverException {
        this.dev.setRelayHyst(relay, value);
    }

    @Command(description="Show relay hysteresis")
    public String showRelayHyst(@Argument(description="Relay number") int relay) throws DriverException {
        return String.valueOf(this.dev.getRelayHyst(relay));
    }

    @Command(description="Set relay trip direction")
    public void setRelayDirn(@Argument(description="Relay number") int relay, @Argument(description="Trip direction") Model9XX.Direction dirn) throws DriverException {
        this.dev.setRelayDirection(relay, dirn);
    }

    @Command(description="Show relay trip direction")
    public Model9XX.Direction showRelayDirn(@Argument(description="Relay number") int relay) throws DriverException {
        return this.dev.getRelayDirection(relay);
    }

    @Command(description="Enable a relay")
    public void setRelayEnable(@Argument(description="Relay number") int relay, @Argument(description="Enable type") Model9XX.Enable enable) throws DriverException {
        this.dev.setRelayEnable(relay, enable);
    }

    @Command(description="Show whether relay enabled")
    public Model9XX.Enable showRelayEnable(@Argument(description="Relay number") int relay) throws DriverException {
        return this.dev.getRelayEnable(relay);
    }

    @Command(description="Show whether relay is active")
    public boolean isRelayActive(@Argument(description="Relay number") int relay) throws DriverException {
        return this.dev.isRelayActive(relay);
    }

    @Command(description="Set relay delayed state")
    public void setRelayDelayed(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.dev.setRelayDelayed(onOff == OnOff.ON);
    }

    @Command(description="Show relay delayed state")
    public OnOff showRelayDelayed() throws DriverException {
        return this.getOnOff(this.dev.isRelayDelayed());
    }

    @Command(description="Set analog output parameters")
    public void setAnalogOut(@Argument(description="Analog channel number (1 - 2)") int chan, @Argument(description="Sensor to use") Model9XX.Sensor sensor, @Argument(description="Analog out curve number") int curve) throws DriverException {
        this.dev.setAnalogOut(chan, sensor, curve);
    }

    @Command(description="Show analog output setting")
    public String showAnalogOut(@Argument(description="Analog channel number (1 - 2)") int chan) throws DriverException {
        return this.dev.getAnalogOut(chan);
    }

    @Command(description="Calibrate cold cathopde vacuum")
    public void calibrateVacuumCC() throws DriverException {
        this.dev.calibrateVacuumCC();
    }

    @Command(description="Calibrate micro-pirani vacuum")
    public void calibrateVacuumMP() throws DriverException {
        this.dev.calibrateVacuumMP();
    }

    @Command(description="Set auto-zero limit")
    public void setAutoZeroLimit(@Argument(description="Pressure") double press) throws DriverException {
        this.dev.setAutoZeroLimit(press);
    }

    @Command(description="Show auto-zero limit")
    public String showAutoZeroLimit() throws DriverException {
        return this.dev.getAutoZeroLimit() + " " + this.getUnitsString();
    }

    @Command(description="Set cold cathode power state")
    public void setCCPower(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.dev.setCCPower(onOff == OnOff.ON);
    }

    @Command(description="Show cold cathods power state")
    public OnOff showCCPower() throws DriverException {
        return this.getOnOff(this.dev.isCCPowerOn());
    }

    @Command(description="Set cold cathode auto power on state")
    public void setCCAutoPower(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.dev.setCCAutoPower(onOff == OnOff.ON);
    }

    @Command(description="Show cold cathods auto power on state")
    public OnOff showCCAutoPower() throws DriverException {
        return this.getOnOff(this.dev.isCCAutoPowerOn());
    }

    @Command(description="Set cold cathode protection state")
    public void setCCProtection(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.dev.setCCProtection(onOff == OnOff.ON);
    }

    @Command(description="Set cold cathode protection delay")
    public void setCCProtDelay(@Argument(description="Delay time (sec)") int delay) throws DriverException {
        this.dev.setCCProtDelay(delay);
    }

    @Command(description="Show cold cathods protection delay")
    public String showCCProtDelay() throws DriverException {
        return this.dev.getCCProtDelay() + " sec";
    }

    @Command(description="Set cold cathode on pressure")
    public void setCCOnPressure(@Argument(description="Pressure") double press) throws DriverException {
        this.dev.setOnPressureCC(press);
    }

    @Command(description="Show cold cathode on pressure")
    public String showCCOnPressure() throws DriverException {
        return this.dev.getOnPressureCC() + " " + this.getUnitsString();
    }

    @Command(description="Set cold cathode off pressure")
    public void setCCOffPressure(@Argument(description="Pressure") double press) throws DriverException {
        this.dev.setOffPressureCC(press);
    }

    @Command(description="Show cold cathode off pressure")
    public String showCCOffPressure() throws DriverException {
        return this.dev.getOffPressureCC() + " " + this.getUnitsString();
    }

    @Command(description="Set high integration pressure")
    public void setHighIntPressure(@Argument(description="Pressure") double press) throws DriverException {
        this.dev.setHighIntPressure(press);
    }

    @Command(description="Show high integration pressure")
    public String showHighIntPressure() throws DriverException {
        return this.dev.getHighIntPressure() + " " + this.getUnitsString();
    }

    @Command(description="Set low integration pressure")
    public void setLowIntPressure(@Argument(description="Pressure") double press) throws DriverException {
        this.dev.setLowIntPressure(press);
    }

    @Command(description="Show low integration pressure")
    public String showLowIntPressure() throws DriverException {
        return this.dev.getLowIntPressure() + " " + this.getUnitsString();
    }

    @Command(description="Set delayed response state")
    public void setDelayedResp(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.dev.setDelayedResponse(onOff == OnOff.ON);
    }

    @Command(description="Show delayed response state")
    public OnOff showDelayedResp() throws DriverException {
        return this.getOnOff(this.dev.isResponseDelayed());
    }

    @Command(description="Set identifying state")
    public void setIdentify(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.dev.setIdentify(onOff == OnOff.ON);
    }

    @Command(description="Show identifying state")
    public OnOff showIdentify() throws DriverException {
        return this.getOnOff(this.dev.isIdentifying());
    }

    @Command(description="Set switch enabled state")
    public void setSwitchEnable(@Argument(description="ON or OFF") OnOff onOff) throws DriverException {
        this.dev.setSwitchEnable(onOff == OnOff.ON);
    }

    @Command(description="Show switch enabled state")
    public OnOff showSwitchEnable() throws DriverException {
        return this.getOnOff(this.dev.isSwitchEnabled());
    }

    @Command(description="Set baud rate")
    public void setBaud(@Argument(description="Baud rate") int baud) throws DriverException {
        this.dev.setBaudRate(baud);
    }

    @Command(description="Show baud rate")
    public int showBaud() throws DriverException {
        return this.dev.getBaudRate();
    }

    @Command(description="Set (change) device address")
    public void setAddress(@Argument(description="Address (1 - 253)") int address) throws DriverException {
        this.dev.changeAddress(address);
    }

    @Command(description="Set response timeout")
    public void setTimeout(@Argument(description="Timeout (secs)") double timeout) throws DriverException {
        this.dev.setTimeout(timeout);
    }

    @Command(description="Show read buffer contents")
    public String showReadBuffer() {
        return this.dev.getReadBuffer();
    }

    private String getUnitsString() throws DriverException {
        return this.dev.getPressureUnit().name().toLowerCase();
    }

    private OnOff getOnOff(boolean value) {
        return value ? OnOff.ON : OnOff.OFF;
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

