/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.bonnshutter.main;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;

public class CommandExecutor {
    private boolean preconditionsMet = true;
    private boolean enterFaultOnError = false;
    private String preconditionsReason = "Preconditions not met";
    private final Agent subsys;
    private Duration duration;
    private static final Alert defaultAlert = new Alert("CMDFAIL", "Command failed");

    public CommandExecutor(Agent subsys) {
        this.subsys = subsys;
    }

    public CommandExecutor precondition(boolean ok) {
        this.preconditionsMet &= ok;
        return this;
    }

    public CommandExecutor precondition(boolean ok, String reason, Object ... args) {
        if (this.preconditionsMet && !ok) {
            this.preconditionsMet = false;
            this.preconditionsReason = args.length > 0 ? String.format(reason, new Object[]{args}) : reason;
        }
        return this;
    }

    CommandExecutor duration(Duration duration) {
        this.duration = duration;
        return this;
    }

    CommandExecutor enterFaultOnError(boolean enterFaultOnError) {
        this.enterFaultOnError = enterFaultOnError;
        return this;
    }

    public <T> T action(Callable<T> callable) {
        this.handlePrecondtions();
        try {
            return callable.call();
        }
        catch (Exception x) {
            throw this.handleException(x);
        }
    }

    public void action(RunnableWithException runnable) {
        this.handlePrecondtions();
        try {
            runnable.run();
        }
        catch (Exception x) {
            throw this.handleException(x);
        }
    }

    private void handlePrecondtions() {
        if (!this.preconditionsMet) {
            this.subsys.sendNack((Serializable)((Object)this.preconditionsReason));
        } else if (this.duration != null) {
            this.subsys.sendAck(this.duration);
        }
    }

    private CommandFailedException handleException(Exception x) {
        if (this.enterFaultOnError) {
            this.subsys.getAlertService().raiseAlert(defaultAlert, AlertState.ALARM, "Execution of command failed unexpectedly");
            return new CommandFailedException("Exception while executing command, fault state entered", x);
        }
        return new CommandFailedException("Unexpected exception during command execution", x);
    }

    public static class CommandFailedException
    extends RuntimeException {
        public CommandFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

