/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.bonnshutter.main;

import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.bonnshutter.BonnShutter;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.bonnshutter.main.ShutterGPIOMonitor;

public class BonnShutterSubsystem
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(BonnShutterSubsystem.class.getName());
    private BonnShutter shutter;
    private final String device = "/dev/ttyS0";
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;

    @Command(type=Command.CommandType.ACTION, level=1, description="Performs a shutter motion calibration")
    public void calibrate() {
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Closes the shutter")
    public void closeShutter() throws DriverException {
        if (!this.subsys.isInState((Enum)ShutterState.OPEN)) {
            throw new IllegalStateException("Shutter is not open");
        }
        this.shutter.closeShutter();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Opens the shutter")
    public void openShutter() throws DriverException {
        if (!this.subsys.isInState((Enum)ShutterState.CLOSED)) {
            throw new IllegalStateException("Shutter is not closed");
        }
        this.shutter.openShutter();
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Performs a timed exposure (open, wait, close)")
    public void takeExposure(@Argument(name="exposureTime", description="The duration of the exposure in seconds") double exposureTime) throws DriverException, InterruptedException {
        if (!this.subsys.isInState((Enum)ShutterState.CLOSED)) {
            throw new IllegalStateException("Shutter is not closed");
        }
        this.shutter.expose((int)(exposureTime * 1000.0));
        this.subsys.waitFor(t -> !t.isInState((Enum)ShutterState.CLOSED), 1L, TimeUnit.SECONDS);
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Wait until exposure complete")
    public void waitForExposure() throws InterruptedException {
        this.subsys.waitFor(t -> t.isInState((Enum)ShutterState.CLOSED), 30L, TimeUnit.SECONDS);
    }

    public void start() {
        this.shutter = new BonnShutter();
        try {
            this.shutter.open("/dev/ttyS0");
            String shutterVersion = this.shutter.getVersion();
            LOG.log(Level.INFO, "Connected to shutter on {0} version {1}", new Object[]{"/dev/ttyS0", shutterVersion});
            BonnShutter.OpenCloseStatus shutterStatus = this.shutter.getOpenCloseStatus();
            switch (shutterStatus) {
                case CLOSED_A: 
                case CLOSED_B: {
                    this.subsys.updateAgentState(new Enum[]{ShutterState.CLOSED});
                    break;
                }
                case OPEN: {
                    this.subsys.updateAgentState(new Enum[]{ShutterState.OPEN});
                    break;
                }
            }
        }
        catch (DriverException ex) {
            LOG.log(Level.SEVERE, "Failed to connect to bonn shutter on {0}", "/dev/ttyS0");
            throw new RuntimeException("Failed to connect to bonn shutter on /dev/ttyS0", ex);
        }
        try {
            ShutterGPIOMonitor gpio = new ShutterGPIOMonitor(this.subsys);
            gpio.start();
            LOG.log(Level.INFO, "GPIO Monitoring running");
        }
        catch (DriverException ex) {
            LOG.log(Level.SEVERE, "Failed to connect to set up GPIO connection to Bonn Shutter", ex);
            throw new RuntimeException("Failed to connect to set up GPIO connection to Bonn Shutter", ex);
        }
    }

    public static enum ShutterState {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }
}

