/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class DataProviderDictionaryImpl
implements DataProviderDictionary {
    private static final long serialVersionUID = -2957175618921765845L;
    private final Map<String, List<DataProviderInfo>> groups = new HashMap<String, List<DataProviderInfo>>();
    private final List<DataProviderInfo> dataProviderInfos = new ArrayList<DataProviderInfo>();
    private final long timestap = System.currentTimeMillis();
    private CCSTimeStamp ccsTimeStamp = CCSTimeStamp.currentTime();

    DataProviderDictionaryImpl() {
    }

    void addDataProviderDescriptionToGroup(DataProviderInfo dpd, String group) {
        List<DataProviderInfo> l;
        if (!this.dataProviderInfos.contains(dpd)) {
            this.dataProviderInfos.add(dpd);
        }
        if ((l = this.groups.get(group)) == null) {
            l = new ArrayList<DataProviderInfo>();
            this.groups.put(group, l);
        }
        if (!l.contains(l)) {
            l.add(dpd);
        }
    }

    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group) {
        return this.groups.get(group);
    }

    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    public List<DataProviderInfo> getDataProviderInfos() {
        return this.dataProviderInfos;
    }

    public long getTimestamp() {
        return this.timestap;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.ccsTimeStamp == null) {
            this.ccsTimeStamp = CCSTimeStamp.currentTimeFromMillis(this.timestap);
        }
    }
}

