/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSourceMenuFactory;
import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.StatisticsBlock;
import jas.plot.DataArea;
import jas.plot.Legend;
import jas.plot.LegendEntry;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

abstract class AbstractDataManager
extends DataManager
implements Runnable {
    protected transient Timer timer;
    protected transient boolean isInit = false;
    protected Legend legend;
    protected StatisticsBlock stats;
    protected transient int nVisible;
    protected transient int nVisibleLegend;
    protected transient Vector data = new Vector();

    AbstractDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats) {
        super(plot, da);
        this.legend = l;
        this.stats = stats;
        this.nVisible = 0;
        this.nVisibleLegend = 0;
        this.xm.setFixed(false);
        this.xm.setRangeAutomatic(true);
        this.ym[0].setFixed(false);
        this.ym[0].setRangeAutomatic(true);
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDataManager.this.doUpdate();
            }
        });
        this.timer.setRepeats(false);
    }

    @Override
    void init() {
        this.computeXAxisRange();
        this.XAxisUpdated();
        this.computeYAxisRange();
        this.isInit = true;
    }

    @Override
    final void invalidate() {
        if (this.isInit) {
            SwingUtilities.invokeLater(this);
        }
    }

    @Override
    public final void run() {
        this.doUpdate();
    }

    @Override
    boolean isRealized() {
        return this.isInit;
    }

    @Override
    void setRealized(boolean b) {
        this.isInit = b;
    }

    @Override
    void requestShow(JASHistData data) {
        LegendEntry le;
        this.da.add(data.getOverlay());
        ++this.nVisible;
        if (this.legend != null && (le = data.getLegendEntry()) != null) {
            this.legend.add(le);
            ++this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.add(data);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.computeYAxisRange();
            this.da.validate();
            this.da.repaint();
        }
    }

    @Override
    void requestHide(JASHistData data) {
        LegendEntry le;
        this.da.remove(data.getOverlay());
        --this.nVisible;
        if (this.legend != null && (le = data.getLegendEntry()) != null) {
            this.legend.remove(le);
            --this.nVisibleLegend;
            this.showLegend();
        }
        if (this.stats != null) {
            this.stats.remove(data);
        }
        if (this.isInit) {
            this.xm.setAttentionNeeded();
            this.computeXAxisRange();
            this.XAxisUpdated();
            this.computeYAxisRange();
            this.da.validate();
            this.da.repaint();
        }
    }

    @Override
    protected void showLegend() {
        int showLegend = this.plot.getShowLegend();
        boolean show = showLegend == 2 || showLegend == 1 && this.nVisibleLegend > 1;
        this.legend.setVisible(show);
        this.legend.revalidate();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDataManager.this.doUpdate();
            }
        });
        this.timer.setRepeats(false);
        this.da.add(this.xm, (Object)"x");
        this.da.add(this.ym[0], (Object)"yl");
        this.da.add(this.ym[1], (Object)"yr");
    }

    abstract void doUpdate();

    @Override
    void remove(JASHistData d) {
        d.show(false);
        d.deleteNormalizationObserver();
        this.data.removeElement(d);
    }

    @Override
    int numberOfDataSources() {
        return this.data.size();
    }

    @Override
    void destroy() {
        Enumeration e = this.data.elements();
        while (e.hasMoreElements()) {
            JASHistData d = (JASHistData)e.nextElement();
            d.show(false);
            d.deleteNormalizationObserver();
        }
        this.data.removeAllElements();
        this.destroyYAxis(1);
        this.stats.clear();
    }

    @Override
    Enumeration getDataSources() {
        return this.data.elements();
    }

    JMenu addPerDataSourceMenu(String name, DataSourceMenuFactory f) {
        int n = this.numberOfDataSources();
        if (n == 0) {
            JMenu result = new JMenu(name);
            result.setEnabled(false);
            return result;
        }
        if (n == 1) {
            JASHistData ds = (JASHistData)this.getDataSources().nextElement();
            return f.createMenu(name, ds);
        }
        JMenu result = new JMenu(name);
        Enumeration e = this.getDataSources();
        int i = 0;
        while (e.hasMoreElements()) {
            JASHistData ds = (JASHistData)e.nextElement();
            JMenu sub = f.createMenu(ds.getTitle(), ds);
            sub.setMnemonic(48 + (char)i);
            result.add(sub);
            ++i;
        }
        return result;
    }
}

