/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.xmlio;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.freehep.jas.plugin.xmlio.XMLIOPlugin;

class XMLIOPluginPrefsDialog
extends JPanel {
    private XMLIOPlugin plugin;
    private String defaultFileName;
    private JCheckBox saveAtExitCheckBox;
    private JCheckBox restoreAtStartCheckBox;
    private JPanel savePanel;
    private JButton defaultFileBrowseButton;
    private JPanel restorePanel;
    private JPanel defaultFilePanel;

    public XMLIOPluginPrefsDialog(XMLIOPlugin plugin) {
        this.plugin = plugin;
        this.initComponents();
        this.defaultFileName = plugin.getDefaultFile();
        this.saveAtExitCheckBox.setSelected(plugin.getSaveAtExit());
        this.restoreAtStartCheckBox.setSelected(plugin.getRestoreAtStart());
    }

    void apply(XMLIOPlugin plugin) {
        plugin.setDefaultFile(this.defaultFileName);
        plugin.setRestoreAtStart(this.restoreAtStartCheckBox.isSelected());
    }

    private void initComponents() {
        this.defaultFilePanel = new JPanel();
        this.defaultFileBrowseButton = new JButton();
        this.restorePanel = new JPanel();
        this.restoreAtStartCheckBox = new JCheckBox();
        this.savePanel = new JPanel();
        this.saveAtExitCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.defaultFilePanel.setLayout(new GridBagLayout());
        this.defaultFileBrowseButton.setText("Set Default Configuration File...");
        this.defaultFileBrowseButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                XMLIOPluginPrefsDialog.this.defaultFileBrowseButtonMouseClicked(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.defaultFilePanel.add((Component)this.defaultFileBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.defaultFilePanel, gridBagConstraints);
        this.restorePanel.setLayout(new GridLayout(1, 0));
        this.restoreAtStartCheckBox.setText("Restore configuration on start");
        this.restoreAtStartCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLIOPluginPrefsDialog.this.restoreAtStartCheckBoxActionPerformed(evt);
            }
        });
        this.restorePanel.add(this.restoreAtStartCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.restorePanel, gridBagConstraints);
        this.savePanel.setLayout(new GridLayout());
        this.saveAtExitCheckBox.setText("Save configuration on exit");
        this.saveAtExitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                XMLIOPluginPrefsDialog.this.saveAtExitCheckBoxActionPerformed(evt);
            }
        });
        this.savePanel.add(this.saveAtExitCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.savePanel, gridBagConstraints);
    }

    private void saveAtExitCheckBoxActionPerformed(ActionEvent evt) {
        this.plugin.setSaveAtExit(this.saveAtExitCheckBox.isSelected());
    }

    private void restoreAtStartCheckBoxActionPerformed(ActionEvent evt) {
        this.plugin.setRestoreAtStart(this.restoreAtStartCheckBox.isSelected());
    }

    private void defaultFileBrowseButtonMouseClicked(MouseEvent evt) {
        String fileName = this.plugin.chooseFile(new File(this.plugin.getDefaultFile()), "Set");
        if (fileName != null) {
            this.defaultFileName = fileName;
        }
    }
}

