/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.dataselection;

import java.util.Comparator;
import java.util.Objects;

public final class DataType {
    private static final String DELIMITER = "$";
    private String name;
    private Boolean raw;
    private int bins;
    private boolean persist;
    private long lastUsed;
    public static final DataType RAW = new DataType(null, true, 0, false);
    public static final DataType DEFAULT = new DataType("Statistical", false, 0, false);

    public DataType(String name, Boolean raw, int bins, boolean persistent) {
        this.name = name;
        if (raw == null || bins < 0 || bins > 1000) {
            throw new IllegalArgumentException("Invalid trending data type parameters: " + raw + ", " + bins);
        }
        this.raw = raw;
        this.bins = bins;
        this.persist = persistent;
        this.lastUsed = System.currentTimeMillis();
    }

    public Boolean getRaw() {
        return this.raw;
    }

    public void setRaw(Boolean raw) {
        this.raw = raw;
    }

    public int getBins() {
        return this.bins;
    }

    public void setBins(int bins) {
        this.bins = bins;
    }

    public String getName() {
        return this.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void setPersistent(boolean persistent) {
        this.persist = persistent;
    }

    public long getLastUseTime() {
        return this.lastUsed;
    }

    public DataType touch() {
        this.lastUsed = System.currentTimeMillis();
        return this;
    }

    public String toString() {
        return this.name == null ? DataType.autoName(this.raw, this.bins) : this.name;
    }

    public String toCompressedString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name).append(DELIMITER);
        }
        if (!this.raw.booleanValue()) {
            sb.append(this.bins);
        }
        return sb.toString();
    }

    public static DataType parseCompressedString(String s) {
        String name = null;
        Boolean raw = true;
        int bins = 0;
        int i = s.indexOf(DELIMITER);
        if (i != -1) {
            name = s.substring(0, i);
            s = s.substring(i + 1);
        }
        if (!s.isEmpty()) {
            raw = false;
            bins = Integer.parseInt(s);
        }
        return new DataType(name, raw, bins, true);
    }

    private static String autoName(boolean raw, int bins) {
        if (raw) {
            return "Raw";
        }
        if (bins > 0) {
            return "Stat " + bins;
        }
        return "Stat";
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType other = (DataType)o;
        return this.getName().equals(other.getName()) && Objects.equals(this.raw, other.raw) && this.bins == other.bins && this.persist == other.persist;
    }

    public int hashCode() {
        int hash = 3;
        hash = 7 * hash + this.getName().hashCode();
        hash = 7 * hash + (this.raw == null ? 47 : this.raw.hashCode());
        hash = 7 * hash + this.bins;
        hash = 7 * hash + (this.persist ? 0 : 1);
        return hash;
    }

    public boolean isReplaceableBy(DataType other) {
        return this.getName().equals(other.getName()) && Objects.equals(this.raw, other.raw) && this.bins == other.bins && (!this.persist || other.persist);
    }

    public static Comparator<DataType> compareByName() {
        return new Comparator<DataType>(){

            @Override
            public int compare(DataType o1, DataType o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
    }

    public static Comparator compareByTime() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)Math.signum(((DataType)o2).getLastUseTime() - ((DataType)o1).getLastUseTime());
            }
        };
    }
}

