package org.lsst.ccs.subsystem.bonnshutter.alerts;

import org.lsst.ccs.bus.data.Alert;

/**
 *  Enumerated Alerts for BonnShutter subsystem
 *
 *  @author Al Eisner
 */
public enum BonnShutterAlerts {

    VOLTAGE         ("VoltageLimit", "Measured voltage out of range"),
    WRONG_STATE     ("WromgState", "Shutter in wrong state fir startup"),
    SHUTTER_ERROR   ("ShutterError", "GPIO read of shutter shows Error State"),
    GPIO_DRIVER     ("GPIODriver", "GPIO DriverException");

    private final String id, description;
    
    BonnShutterAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert newAlert() {
        return new Alert(getId(), getDescription());
    }

}
