/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats;

import java.io.Serializable;
import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.ats.data.AtsState;

public class AtsMain
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    private static final Logger LOG = Logger.getLogger(AtsMain.class.getName());

    public AtsMain() {
        super("ats", AgentInfo.AgentType.WORKER);
    }

    public void postInit() {
        ((AgentPropertiesService)this.subsys.getAgentService(AgentPropertiesService.class)).setAgentProperty("atsType", AtsMain.class.getCanonicalName());
    }

    public void postStart() {
        LOG.info("ATS subsystem started");
    }

    public AtsState getState() {
        return new AtsState(this.getTickPeriod());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the ATS system state", level=0)
    public AtsState getSystemState() {
        return this.getState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("AtsState", (Serializable)this.getState()));
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }
}

