/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

class DataProviderDictionaryImpl
implements DataProviderDictionary {
    private static final long serialVersionUID = 5717561561765845L;
    private final Map<String, List<DataProviderInfo>> groups = new HashMap<String, List<DataProviderInfo>>();
    private final Map<String, DataProviderInfo> pathMap = new HashMap<String, DataProviderInfo>();
    private final List<DataProviderInfo> dataProviderInfos = new ArrayList<DataProviderInfo>();
    private final CCSTimeStamp ccsTimeStamp = CCSTimeStamp.currentTime();
    private static final Logger LOG = Logger.getLogger(DataProviderDictionaryImpl.class.getName());

    DataProviderDictionaryImpl() {
    }

    void addDataProviderDescriptionToGroup(DataProviderInfo dpd, String group) {
        String path;
        List<DataProviderInfo> l;
        if (!this.dataProviderInfos.contains(dpd)) {
            this.dataProviderInfos.add(dpd);
        }
        if ((l = this.groups.get(group)) == null) {
            l = new ArrayList<DataProviderInfo>();
            this.groups.put(group, l);
        }
        if (!l.contains(dpd)) {
            l.add(dpd);
        }
        if (this.pathMap.containsKey(path = dpd.getFullPath())) {
            if (!dpd.equals(this.pathMap.get(path))) {
                LOG.log(Level.SEVERE, "Cannot register DataProviderInfo for {0} {1}. One entry for that path already exists: {2}", new Object[]{path, dpd, this.pathMap.get(path)});
            }
        } else {
            this.pathMap.put(path, dpd);
        }
    }

    public List<DataProviderInfo> getDataProviderDescriptionsForGroup(String group) {
        return this.groups.get(group);
    }

    public Set<String> getGroups() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.groups.keySet());
        return result;
    }

    public List<DataProviderInfo> getDataProviderInfos() {
        return this.dataProviderInfos;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public DataProviderInfo getDataProviderInfoForPath(String path) {
        return this.pathMap.get(path);
    }
}

