/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats.ui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.ats.data.AtsState;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class AtsMonitorPanel
extends JPanel
implements CommandSender.ReplyHandler {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private static final long serialVersionUID = 1L;

    public AtsMonitorPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getSystemState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((AtsState)reply);
    }

    public void updatePanel(AtsState state) {
        SwingUtilities.invokeLater(new UpdatePanel(state));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.add((Component)this.statusPanel);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            AtsMonitorPanel.this.statusPanel.disablePanel();
            AtsMonitorPanel.this.repaint();
        }
    }

    class UpdatePanel
    implements Runnable {
        private final AtsState state;

        UpdatePanel(AtsState state) {
            this.state = state;
        }

        @Override
        public void run() {
            AtsMonitorPanel.this.statusPanel.updatePanel(this.state.getTickMillis());
            AtsMonitorPanel.this.repaint();
        }
    }
}

