/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats.ui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.ats.data.AtsState;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;

public class AtsMonitorPanel
extends JPanel {
    private final CommandSender sender;
    private SystemStatusPanel statusPanel;
    private static final long serialVersionUID = 1L;

    public AtsMonitorPanel(CommandSender sender) {
        this.sender = sender;
        this.initComponents();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.statusPanel = new SystemStatusPanel(this.sender);
        this.add((Component)this.statusPanel);
    }

    public void updateControlPanel(AtsState state) {
        SwingUtilities.invokeLater(new UpdateControlPanel(state));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            AtsMonitorPanel.this.statusPanel.disableSystem();
            AtsMonitorPanel.this.repaint();
        }
    }

    class UpdateControlPanel
    implements Runnable {
        private final AtsState state;

        UpdateControlPanel(AtsState state) {
            this.state = state;
        }

        @Override
        public void run() {
            AtsMonitorPanel.this.statusPanel.updateStatus(this.state.getTickMillis());
            AtsMonitorPanel.this.repaint();
        }
    }
}

