package org.lsst.ccs.subsystem.ats.ui;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.ats.data.AtsState;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;

/**
 *  Implements a minimal control panel.
 *
 *  @author Owen Saxton
 */
public class AtsMonitorPanel extends JPanel {

    private final CommandSender sender;
    private SystemStatusPanel statusPanel;

    public AtsMonitorPanel(CommandSender sender) {
        this.sender = sender;
        initComponents();
        (new DisableSystem()).run();
    }

    private void initComponents()
    {
        // Status line panel
        statusPanel = new SystemStatusPanel(sender);
        
        // Whole panel
        add(statusPanel);
    }

    public void updateControlPanel(AtsState state) {
        SwingUtilities.invokeLater(new UpdateControlPanel(state));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    class UpdateControlPanel implements Runnable {

        private final AtsState state;

        UpdateControlPanel(AtsState state) {
            this.state = state;
        }

        @Override
        public void run() {
            statusPanel.updateStatus(state.getTickMillis());
            repaint();
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            statusPanel.disableSystem();
            repaint();
        } 
    }

    private static final long serialVersionUID = 1L;
}
