/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jgroups.util.Util;

public class Version {
    public static final short major;
    public static final short minor;
    public static final short micro;
    public static final String description;
    public static final short version;
    public static final String string_version;
    private static final int MAJOR_SHIFT = 11;
    private static final int MINOR_SHIFT = 6;
    private static final int MAJOR_MASK = 63488;
    private static final int MINOR_MASK = 1984;
    private static final int MICRO_MASK = 63;
    public static final String VERSION_FILE = "JGROUPS_VERSION.properties";
    public static final String VERSION_PROPERTY = "jgroups.version";
    public static final String CODENAME = "jgroups.codename";
    private static final Pattern VERSION_REGEXP;

    public static void main(String[] args) {
        System.out.println("\nVersion:      " + description);
    }

    public static String printDescription() {
        return "JGroups " + description;
    }

    public static String printVersion() {
        return string_version;
    }

    public static boolean isSame(short v) {
        return version == v;
    }

    public static short encode(int major, int minor, int micro) {
        return (short)((major << 11) + (minor << 6) + micro);
    }

    public static String print(short version) {
        int major = (version & 0xF800) >> 11;
        int minor = (version & 0x7C0) >> 6;
        int micro = version & 0x3F;
        return major + "." + minor + "." + micro;
    }

    public static short[] decode(short version) {
        short major = (short)((version & 0xF800) >> 11);
        short minor = (short)((version & 0x7C0) >> 6);
        short micro = (short)(version & 0x3F);
        return new short[]{major, minor, micro};
    }

    public static boolean isBinaryCompatible(short ver) {
        if (version == ver) {
            return true;
        }
        short tmp_major = (short)((ver & 0xF800) >> 11);
        short tmp_minor = (short)((ver & 0x7C0) >> 6);
        return major == tmp_major && minor == tmp_minor;
    }

    public static boolean isBinaryCompatible(short ver1, short ver2) {
        if (ver1 == ver2) {
            return true;
        }
        short[] tmp = Version.decode(ver1);
        short tmp_major = tmp[0];
        short tmp_minor = tmp[1];
        tmp = Version.decode(ver2);
        short tmp_major2 = tmp[0];
        short tmp_minor2 = tmp[1];
        return tmp_major == tmp_major2 && tmp_minor == tmp_minor2;
    }

    static {
        VERSION_REGEXP = Pattern.compile("((\\d+)\\.(\\d+)\\.(\\d+).*)");
        Properties properties = new Properties();
        String ver = null;
        String codename = "n/a";
        InputStream manifestAsStream = null;
        try {
            manifestAsStream = Util.getResourceAsStream(VERSION_FILE, Version.class);
            if (manifestAsStream == null) {
                throw new FileNotFoundException(VERSION_FILE);
            }
            properties.load(manifestAsStream);
            ver = properties.getProperty(VERSION_PROPERTY);
            if (ver == null) {
                throw new Exception("value for jgroups.version not found in JGROUPS_VERSION.properties");
            }
            codename = properties.getProperty(CODENAME, "n/a");
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize version", e);
        }
        finally {
            Util.close((Closeable)manifestAsStream);
        }
        Matcher versionMatcher = VERSION_REGEXP.matcher(ver);
        versionMatcher.find();
        description = String.format("%s (%s)", ver, codename);
        major = Short.parseShort(versionMatcher.group(2));
        minor = Short.parseShort(versionMatcher.group(3));
        micro = Short.parseShort(versionMatcher.group(4));
        version = Version.encode(major, minor, micro);
        string_version = Version.print(version);
    }
}

