/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.ats.data.AtsState;
import org.lsst.ccs.subsystem.ats.ui.jas.CommandSender;

public class AtsMonitorPanel
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    private final CommandSender gui;
    private final JPanel topPanel = new JPanel();
    private final JPanel statePanel = new JPanel();
    private final JLabel stateLabel = new JLabel("System State: ");
    private final JLabel stateStatus = new JLabel("....");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JTextField periodTextField = new JTextField("...");
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private String mainName;
    private double mainPeriod = 5.0;
    private static final long serialVersionUID = 1L;

    public AtsMonitorPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        new UpdateSystemStatus(new AtsState(0)).run();
        new DisableSystem().run();
    }

    public void setSubsystem(String mainName) {
        this.mainName = mainName;
    }

    private void initComponents() {
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 70;
        this.stateStatus.setPreferredSize(d);
        this.stateStatus.setMinimumSize(d);
        d = this.periodTextField.getPreferredSize();
        d.width = 50;
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AtsMonitorPanel.this.setUpdatePeriod();
            }
        });
        this.statePanel.add(this.stateLabel);
        this.statePanel.add(this.stateStatus);
        this.periodPanel.add(this.periodLabel);
        this.periodPanel.add(this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        GridBagConstraints gbt = new GridBagConstraints();
        this.topPanel.setLayout(new GridBagLayout());
        gbt.gridx = 0;
        gbt.gridy = 0;
        this.topPanel.add((Component)this.statePanel, gbt);
        gbt.insets.left = 80;
        ++gbt.gridx;
        this.topPanel.add((Component)this.periodPanel, gbt);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.anchor = 11;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.topPanel, gbc);
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.gui.sendCommand(this.mainName, null, "setUpdatePeriod", (int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.mainPeriod));
        }
    }

    public void updateSystemStatus(AtsState rs) {
        SwingUtilities.invokeLater(new UpdateSystemStatus(rs));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            AtsMonitorPanel.this.stateStatus.setText("STOPPED");
            AtsMonitorPanel.this.stateStatus.setForeground(RED);
            AtsMonitorPanel.this.periodTextField.setEnabled(false);
        }
    }

    class UpdateSystemStatus
    implements Runnable {
        private final AtsState rs;

        UpdateSystemStatus(AtsState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            AtsMonitorPanel.this.stateStatus.setText("RUNNING");
            AtsMonitorPanel.this.stateStatus.setForeground(GREEN);
            AtsMonitorPanel.this.periodTextField.setEnabled(true);
            AtsMonitorPanel.this.mainPeriod = (double)this.rs.getTickMillis() / 1000.0;
            AtsMonitorPanel.this.periodTextField.setText(String.valueOf(AtsMonitorPanel.this.mainPeriod));
        }
    }
}

