/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ats.ui.jas;

import javax.swing.JPanel;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.ats.data.AtsState;
import org.lsst.ccs.subsystem.ats.ui.AtsMonitorPanel;
import org.lsst.ccs.subsystem.ats.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.ats.ui.jas.Control;
import org.lsst.ccs.subsystem.ats.ui.jas.StdOptionalPage;

@Plugin(name="ATS Control Plugin", description="ATS Control Plugin")
public class AtsControlPlugin
extends ConsolePlugin {
    public void initialize() {
        StdOptionalPage optPage = new StdOptionalPage("atsType", AtsControl.class);
        Console.getConsole().getOptionalPageService().add((OptionalPage)optPage);
    }

    static class AtsControl
    implements Control,
    StatusMessageListener {
        private AtsMonitorPanel ctrlPanel;

        AtsControl() {
        }

        public void onStatusMessage(StatusMessage msg) {
            try {
                StatusSubsystemData sd = (StatusSubsystemData)msg;
                if (sd.getDataKey().equals("AtsState")) {
                    this.updateControlPanel(sd.getSubsystemData().getValue());
                }
            }
            catch (EmbeddedObjectDeserializationException embeddedObjectDeserializationException) {
                // empty catch block
            }
        }

        @Override
        public void updateControlPanel(Object obj) {
            this.ctrlPanel.updateSystemStatus((AtsState)obj);
        }

        @Override
        public void disableSystem() {
            this.ctrlPanel.disableSystem();
        }

        @Override
        public JPanel getControlPanel(CommandSender sndr) {
            this.ctrlPanel = new AtsMonitorPanel(sndr);
            return this.ctrlPanel;
        }

        @Override
        public void setSubsystems(String name) {
            this.ctrlPanel.setSubsystem(name);
        }

        @Override
        public StatusMessageListener getListener() {
            return this;
        }
    }
}

