package org.lsst.ccs.subsystem.ats.data;

import java.io.Serializable;

/**
 *  Contains the state of the ATS subsystem
 *
 *  @author Owen Saxton
 */
public class AtsState implements Serializable {

    public static final String KEY = "AtsState";

    private final int tickMillis;        // Data status update period (ms)

    public AtsState(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    private static final long serialVersionUID = -5970037681245971472L;
}
