/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import org.astrogrid.samp.client.SampException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.drivers.archon.RawImageData;
import org.lsst.ccs.subsystem.archon.FitsUtilities;
import org.lsst.ccs.subsystem.archon.ImageHandler;
import org.lsst.ccs.subsystem.archon.RawImageConverter;
import org.lsst.ccs.subsystem.archon.RawImageConverterTest;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDType;

public class FitsUtilitiesTest {
    @Test
    public void testFluxStats() throws FitsException, IOException {
        CCDGeometry ccdGeom = CCDType.E2V.getGeometry();
        HashMap<String, Double> extra = new HashMap<String, Double>();
        extra.put("ExposureTime", 15.0);
        HashMap<String, Map<String, Object>> metaDataMap = new HashMap<String, Map<String, Object>>();
        metaDataMap.put("extra", extra);
        File file = this.testWriteFitsFile("imageE2V", ccdGeom, metaDataMap);
        FitsUtilities fitsUtil = new FitsUtilities();
        double fluxStats = fitsUtil.getFluxStats(file);
        Assert.assertEquals((double)215.0, (double)fluxStats, (double)1.0);
    }

    @Test
    public void testReadPDValues() throws IOException {
        File tmp = File.createTempFile("pdvalues", "txt");
        tmp.deleteOnExit();
        try (InputStream resourceAsStream = FitsUtilitiesTest.class.getResourceAsStream("/pd-values.txt");){
            Files.copy(resourceAsStream, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        FitsUtilities fitsUtil = new FitsUtilities();
        List data = fitsUtil.readPhotoDiodeFile(tmp);
        Assert.assertEquals((long)226L, (long)data.size());
        double result = fitsUtil.analyzePhotoDiodeValues(data);
        Assert.assertEquals((double)-15.3, (double)result, (double)0.1);
    }

    @Test
    public void testUpdatePhotoDiodeValues() throws IOException, FitsException {
        File tmp = File.createTempFile("pdvalues", "txt");
        tmp.deleteOnExit();
        try (InputStream resourceAsStream = FitsUtilitiesTest.class.getResourceAsStream("/pd-values.txt");){
            Files.copy(resourceAsStream, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        CCDGeometry ccdGeom = CCDType.E2V.getGeometry();
        HashMap<String, Map<String, Object>> metaDataMap = new HashMap<String, Map<String, Object>>();
        File fits = this.testWriteFitsFile("imageE2V", ccdGeom, metaDataMap);
        FitsUtilities fitsUtil = new FitsUtilities();
        fitsUtil.updatePhotoDiodeValues(tmp, fits, "xxx", "aaa", "bbb", 0.0);
        try (Fits read = new Fits(fits);){
            read.read();
            BasicHDU primary = read.getHDU(0);
            Assert.assertEquals((double)-15.3, (double)primary.getHeader().getDoubleValue("MONDIODE"), (double)0.1);
            BasicHDU last = read.getHDU(read.getNumberOfHDUs() - 1);
            Assert.assertEquals((double)0.0, (double)last.getHeader().getDoubleValue("TSTART"), (double)1.0E-6);
            Assert.assertEquals((Object)"xxx", (Object)last.getHeader().getStringValue("EXTNAME"));
            Assert.assertEquals((long)226L, (long)last.getHeader().getIntValue("NAXIS2"));
            Assert.assertEquals((long)16L, (long)last.getHeader().getIntValue("NAXIS1"));
        }
        RawImageConverterTest.testCheckSum(fits);
    }

    private File testWriteFitsFile(String name, CCDGeometry ccdGeom, Map<String, Map<String, Object>> metaDataMap) throws FitsException, IOException, SampException {
        RawImageData testImage = RawImageData.createRippledImage((CCDGeometry)ccdGeom);
        RawImageConverter converter = new RawImageConverter(testImage, ccdGeom);
        File tempFile = File.createTempFile(name, "fits");
        tempFile.deleteOnExit();
        ImageHandler imageHandler = new ImageHandler();
        imageHandler.writeImage(tempFile, converter, metaDataMap);
        return tempFile;
    }
}

