/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.StateBundle;

public class StatusData
extends StatusMessage<KeyValueData, KeyValueDataList> {
    private static final long serialVersionUID = -12962837209683823L;

    public StatusData(KeyValueData obj, StateBundle state) {
        super(obj, state);
    }

    @Override
    protected KeyValueDataList encodeObject(KeyValueData obj) {
        return EncodingUtils.encodeObject(obj);
    }

    @Override
    public KeyValueDataList getEncodedData() {
        return (KeyValueDataList)super.getEncodedData();
    }

    private static class EncodingUtils {
        private static final Object SKIP_ENCODING = new Object();
        private static final ConcurrentHashMap<Class, ClassDescriptor> classMap = new ConcurrentHashMap();
        private static final Class[] WELL_KNOWN_TYPES = new Class[]{Boolean.class, Boolean.TYPE, Integer.class, Integer.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Long.class, Long.TYPE, String.class, byte[].class, boolean[].class, int[].class, float[].class, double[].class, long[].class, String[].class, BitSet.class, BigDecimal.class, List.class, Map.class};
        private static final ClassDescriptor NULL_DESCRIPTOR = new ClassDescriptor(null){

            public String toString() {
                return "NULL_DESCRIPTOR";
            }
        };
        private static final ClassDescriptor ENUM_DESCRIPTOR = new ClassDescriptor(null){

            public String toString() {
                return "ENUM_DESCRIPTOR";
            }
        };

        private EncodingUtils() {
        }

        private static ClassDescriptor getDescriptorFor(Class clazz) {
            if (Map.class.isAssignableFrom(clazz)) {
                return NULL_DESCRIPTOR;
            }
            ClassDescriptor first = classMap.get(clazz);
            if (first == null) {
                first = EncodingUtils.buildDescriptorFor(clazz);
                classMap.put(clazz, first);
            }
            return first;
        }

        private static synchronized ClassDescriptor buildDescriptorFor(Class clazz) {
            Field[] fields;
            ClassDescriptor superDescriptor;
            if (clazz.isEnum()) {
                return ENUM_DESCRIPTOR;
            }
            ArrayList<Field> listFields = new ArrayList<Field>();
            Class superClazz = clazz.getSuperclass();
            if (superClazz != null && !Object.class.equals(superClazz) && (superDescriptor = EncodingUtils.getDescriptorFor(superClazz)) != NULL_DESCRIPTOR && superDescriptor.mapFields != null) {
                listFields.addAll(superDescriptor.mapFields.values());
            }
            for (Field field : fields = clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) && !Serializable.class.isAssignableFrom(field.getType()) || field.getAnnotation(SkipEncoding.class) != null) continue;
                field.setAccessible(true);
                listFields.add(field);
            }
            ClassDescriptor res = new ClassDescriptor(listFields);
            return res;
        }

        public static final KeyValueDataList encodeObject(KeyValueData value) {
            String key = "";
            long t = value.getTimestamp();
            Object obj = EncodingUtils.innerEncodeObject(value, key, t);
            if (obj instanceof KeyValueDataList) {
                return (KeyValueDataList)obj;
            }
            if (obj == null) {
                return null;
            }
            KeyValueDataList d = new KeyValueDataList();
            EncodingUtils.addObjectToDataList(key, obj, d, t, KeyValueData.KeyValueDataType.KeyValueTrendingData);
            return d;
        }

        protected static final Object innerEncodeObject(Object value, String key, long timestamp) {
            if (value == null) {
                return null;
            }
            Class<?> clazz = value.getClass();
            if (clazz.getAnnotation(SkipEncoding.class) != null) {
                return SKIP_ENCODING;
            }
            ClassDescriptor descriptor = EncodingUtils.getDescriptorFor(clazz);
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                KeyValueDataList dataList = new KeyValueDataList();
                for (Object val : c) {
                    Object o = EncodingUtils.innerEncodeObject(val, key, timestamp);
                    if (o == SKIP_ENCODING) continue;
                    EncodingUtils.addObjectToDataList(key, o, dataList, timestamp, KeyValueData.KeyValueDataType.KeyValueTrendingData);
                }
                return dataList;
            }
            boolean isMap = value instanceof Map;
            if (isMap) {
                Map map = (Map)value;
                KeyValueDataList dataList = new KeyValueDataList();
                for (Object obj : map.keySet()) {
                    String name = EncodingUtils.updateName(obj.toString(), key);
                    Object o = EncodingUtils.innerEncodeObject(map.get(obj), name, timestamp);
                    if (o == SKIP_ENCODING) continue;
                    EncodingUtils.addObjectToDataList(name, o, dataList, timestamp, KeyValueData.KeyValueDataType.KeyValueTrendingData);
                }
                return dataList;
            }
            if (value instanceof BitSet) {
                BitSet bitset = (BitSet)value;
                if (bitset.length() > 64) {
                    throw new RuntimeException("Cannot encode a BitSet with more than 64 bits");
                }
                long l = 0L;
                for (int i = 0; i < bitset.length(); ++i) {
                    l += bitset.get(i) ? 1L << i : 0L;
                }
                return l;
            }
            if (descriptor == NULL_DESCRIPTOR) {
                return value;
            }
            if (descriptor == ENUM_DESCRIPTOR) {
                return String.valueOf(value);
            }
            if (value instanceof KeyValueData) {
                KeyValueDataList res = new KeyValueDataList();
                KeyValueData kvd = (KeyValueData)value;
                timestamp = kvd.getTimestamp();
                String name = EncodingUtils.updateName(kvd.getKey(), key);
                Object o = EncodingUtils.innerEncodeObject(kvd.getValue(), name, timestamp);
                if (o != SKIP_ENCODING) {
                    EncodingUtils.addObjectToDataList(name, o, res, timestamp, kvd.getType());
                }
                return res;
            }
            Collection<Field> descriptorValues = descriptor.mapFields.values();
            KeyValueDataList res = new KeyValueDataList();
            if (value instanceof Exception) {
                ((Exception)value).printStackTrace();
            }
            for (Field field : descriptorValues) {
                try {
                    String name = EncodingUtils.updateName(field.getName(), key);
                    Object val = EncodingUtils.innerEncodeObject(field.get(value), name, timestamp);
                    if (val == SKIP_ENCODING) continue;
                    EncodingUtils.addObjectToDataList(name, val, res, timestamp, KeyValueData.KeyValueDataType.KeyValueTrendingData);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException("Something went really wrong encoding the object.", e);
                }
            }
            return res;
        }

        private static String updateName(String name, String prefix) {
            String tmpName = name;
            if (prefix != null && !prefix.isEmpty()) {
                tmpName = prefix + "/" + tmpName;
            }
            return tmpName;
        }

        private static void addObjectToDataList(String name, Object val, KeyValueDataList res, long timestamp, KeyValueData.KeyValueDataType type) {
            if (val instanceof KeyValueDataList) {
                for (KeyValueData d : (KeyValueDataList)val) {
                    res.addData(d);
                }
            } else if (val instanceof KeyValueData) {
                res.addData((KeyValueData)val);
            } else {
                res.addData(name, (Serializable)val, timestamp, type);
            }
        }

        static {
            for (Class clazz : WELL_KNOWN_TYPES) {
                classMap.put(clazz, NULL_DESCRIPTOR);
            }
        }

        private static class ClassDescriptor {
            final LinkedHashMap<String, Field> mapFields;

            ClassDescriptor(List<Field> fieldList) {
                if (fieldList != null) {
                    this.mapFields = new LinkedHashMap();
                    for (Field field : fieldList) {
                        this.mapFields.put(field.getName(), field);
                    }
                } else {
                    this.mapFields = null;
                }
            }
        }
    }
}

