/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.image.DateUtils;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;

public class FitsFileWriter
implements Closeable {
    private final BufferedFile bf;
    private final ImageExtension[] imageExtensions;

    public FitsFileWriter(File file, ImageSet images, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config, BitsPerPixel bits) throws IOException, FitsException {
        Header header;
        this.imageExtensions = new ImageExtension[images.getImages().size()];
        int[][] intDummyData = new int[1][1];
        short[][] shortDummyData = new short[1][1];
        Object[] tableDummyData = new Object[]{};
        Object dummyData = bits == BitsPerPixel.BIT16 ? shortDummyData : (Object)intDummyData;
        this.bf = new BufferedFile(file, "rw");
        FitsFactory.setUseHierarch(true);
        HashMap<String, Map<String, Object>> fullMetaData = new HashMap<String, Map<String, Object>>(metaData);
        fullMetaData.put("imageSet", images.getMetaData());
        BasicHDU<?> primary = BasicHDU.getDummyHDU();
        this.addMetaDataToHeader(primary, "primary", fullMetaData, config);
        FitsCheckSum.setChecksum(primary);
        primary.getHeader().write(this.bf);
        int i = 0;
        for (ImageSet.Image image : images.getImages()) {
            BasicHDU<?> hdu = FitsFactory.HDUFactory(dummyData);
            this.addMetaDataToHeader(hdu, "extended", image.getMetaData(), config);
            if (bits == BitsPerPixel.BIT16) {
                hdu.addValue("BSCALE", 1.0, "Unsigned 16 bit data");
                hdu.addValue("BZERO", 32768, "Unsigned 16 bit data");
            }
            header = hdu.getHeader();
            header.setXtension("IMAGE");
            header.setNaxis(1, image.getWidth());
            header.setNaxis(2, image.getHeight());
            FitsCheckSum.setChecksum(hdu);
            long start = this.bf.getFilePointer();
            header.write(this.bf);
            long current = this.bf.getFilePointer();
            long imageSize = (bits == BitsPerPixel.BIT16 ? 2L : 4L) * (long)image.getWidth() * (long)image.getHeight();
            this.bf.seek(this.bf.getFilePointer() + imageSize);
            FitsUtil.pad(this.bf, imageSize);
            this.imageExtensions[i++] = new ImageExtension(start, current, this.bf.getFilePointer(), header);
        }
        FitsFactory.setUseAsciiTables(false);
        for (String key : config.keySet()) {
            if ("primary".equals(key) || "extended".equals(key)) continue;
            BasicHDU<?> binary = FitsFactory.HDUFactory(tableDummyData);
            this.addMetaDataToHeader(binary, key, fullMetaData, config);
            header = binary.getHeader();
            header.setXtension("BINTABLE");
            FitsCheckSum.setChecksum(binary);
            header.write(this.bf);
        }
    }

    public void write(int imageIndex, ByteBuffer src) throws IOException {
        this.imageExtensions[imageIndex].write(src);
    }

    @Override
    public void close() throws IOException {
        ImageExtension[] imageExtensionArray = this.imageExtensions;
        int n = this.imageExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            ImageExtension imageExtension = imageExtensionArray[n2];
            imageExtension.updateDataSum();
            ++n2;
        }
        this.bf.close();
    }

    private void addMetaDataToHeader(BasicHDU hdu, String specName, Map<String, Map<String, Object>> metaData, Map<String, HeaderSpecification> config) throws HeaderCardException, IOException {
        HeaderSpecification spec = config.get(specName);
        if (spec == null) {
            throw new IOException("Missing specification for header: " + specName);
        }
        for (HeaderSpecification.HeaderLine header : spec.getHeaders()) {
            Object value = header.getValue(metaData);
            try {
                if (value == null) continue;
                switch (header.getDataType()) {
                    case Integer: {
                        hdu.addValue(header.getKeyword(), ((Number)value).intValue(), header.getComment());
                        break;
                    }
                    case Float: {
                        double data = ((Number)value).doubleValue();
                        if (!Double.isFinite(data)) {
                            throw new IllegalArgumentException("Can not store non-finite floating point in FITS file");
                        }
                        hdu.addValue(header.getKeyword(), data, header.getComment());
                        break;
                    }
                    case Boolean: {
                        hdu.addValue(header.getKeyword(), (Boolean)value, header.getComment());
                        break;
                    }
                    case Date: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToString((Date)value), header.getComment());
                        break;
                    }
                    case MJD: {
                        hdu.addValue(header.getKeyword(), DateUtils.convertDateToMJD((Date)value), header.getComment());
                        break;
                    }
                    default: {
                        hdu.addValue(header.getKeyword(), String.valueOf(value), header.getComment());
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                throw new IOException(String.format("Meta-data header %s with value %s(%s) cannot be converted to type %s", new Object[]{header.getKeyword(), value, value.getClass(), header.getDataType()}));
            }
        }
    }

    public static enum BitsPerPixel {
        BIT16,
        BIT32;

    }

    private class ImageExtension {
        private final long startPosition;
        private final long endPosition;
        private long currentPosition;
        private final FitsCheckSum.Checksum checkSum;
        private final Header header;

        private ImageExtension(long start, long current, long end, Header header) {
            this.startPosition = start;
            this.currentPosition = current;
            this.endPosition = end;
            this.header = header;
            this.checkSum = new FitsCheckSum.Checksum();
        }

        /*
         * Unable to fully structure code
         */
        private void write(ByteBuffer src) throws IOException {
            block2: {
                length = src.remaining();
                if ((long)length + this.currentPosition > this.endPosition) {
                    throw new IOException("Too much data written for image");
                }
                FitsCheckSum.updateChecksum(src, this.checkSum);
                FitsFileWriter.access$0(FitsFileWriter.this).seek(this.currentPosition);
                if (!src.hasArray()) ** GOTO lbl13
                FitsFileWriter.access$0(FitsFileWriter.this).write(src.array(), src.arrayOffset() + src.position(), src.remaining());
                src.position(src.limit());
                break block2;
lbl-1000:
                // 1 sources

                {
                    FitsFileWriter.access$0(FitsFileWriter.this).write(src.get());
lbl13:
                    // 2 sources

                    ** while (src.remaining() > 0)
                }
            }
            this.currentPosition += (long)length;
        }

        private void updateDataSum() throws IOException {
            try {
                FitsCheckSum.updateDataSum(this.header, this.checkSum.getCheckSum());
                FitsFileWriter.this.bf.seek(this.startPosition);
                this.header.write(FitsFileWriter.this.bf);
            }
            catch (FitsException ex) {
                throw new IOException("Unable to add datasum to header", ex);
            }
        }
    }
}

