/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.utilities.image.ImageSet;

public class DefaultImageSet
implements ImageSet {
    private final List<ImageSet.Image> images = new ArrayList<ImageSet.Image>();
    private final HashMap<String, Object> metaData = new HashMap();

    public DefaultImageSet() {
    }

    public DefaultImageSet(Map<String, Object> metaData) {
        this.metaData.putAll(metaData);
    }

    @Override
    public List<ImageSet.Image> getImages() {
        return Collections.unmodifiableList(this.images);
    }

    @Override
    public Map<String, Object> getMetaData() {
        return Collections.unmodifiableMap(this.metaData);
    }

    public void addImage(int width, int height, Map<String, Map<String, Object>> metaData) {
        this.images.add(new DefaultImage(width, height, metaData));
    }

    private static class DefaultImage
    implements ImageSet.Image {
        private final int width;
        private final int height;
        private final HashMap<String, Map<String, Object>> metaData = new HashMap();

        public DefaultImage(int width, int height, Map<String, Map<String, Object>> metaData) {
            this.width = width;
            this.height = height;
            this.metaData.putAll(metaData);
        }

        @Override
        public Map<String, Map<String, Object>> getMetaData() {
            return Collections.unmodifiableMap(this.metaData);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }
    }
}

