/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.archon.RawImageData;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDTransform;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class RawImageConverter {
    private static final Logger logger = Logger.getLogger(RawImageConverter.class.getName());
    private final CCDGeometry geom;
    private final DefaultImageSet imageSet;
    private final RawImageData rawImage;
    private static final int BUFFER_SIZE = 1000000;
    private double imageAverageSignal = 0.0;

    RawImageConverter(RawImageData rawImage, CCDGeometry geom) {
        this(rawImage, geom, false);
    }

    RawImageConverter(RawImageData rawImage, CCDGeometry geom, boolean treatOverAndUnderscanAsActive) {
        this.rawImage = rawImage;
        this.geom = geom;
        assert (rawImage.getData().length == rawImage.getSample().bytes() * geom.getTotalSerialSize() * geom.getTotalParallelSize());
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("ArchonSample", rawImage.getSample());
        metaData.put("ArchonFrameMode", rawImage.getFrameMode());
        metaData.put("ArchonTimestamp", rawImage.getTimestamp());
        metaData.putAll(geom.getPrimaryHeaders());
        this.imageSet = new DefaultImageSet(metaData);
        ByteBuffer raw = ByteBuffer.wrap(rawImage.getData());
        raw.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer shortRaw = raw.asShortBuffer();
        CCDTransform global = geom.getGlobalTransform();
        long start = System.currentTimeMillis();
        for (CCDGeometry.CCDSegment segment : geom.getSegments()) {
            MetaDataSet metaDataSet = new MetaDataSet();
            Map imageMetaData = segment.getSegmentHeaders(treatOverAndUnderscanAsActive);
            this.analyzeImage(global, shortRaw, segment, imageMetaData);
            metaDataSet.addMetaData("channel", imageMetaData);
            this.imageSet.addImage(geom.getTotalSerialCount(), geom.getTotalParallelCount(), (Map)metaDataSet);
        }
        long stop = System.currentTimeMillis();
        logger.log(Level.FINE, "Analyzed image in {0}ms", stop - start);
    }

    public double getImageAverageSignal() {
        return this.imageAverageSignal;
    }

    ImageSet getImageSet() {
        return this.imageSet;
    }

    private void analyzeImage(CCDTransform global, ShortBuffer shortRaw, CCDGeometry.CCDSegment segment, Map<String, Object> imageMetaData) {
        double pix_sum_active = 0.0;
        double pix_sum_sq_active = 0.0;
        int npix_active = 0;
        double pix_sum_bias = 0.0;
        double pix_sum_sq_bias = 0.0;
        int npix_bias = 0;
        for (int col = 0; col < this.geom.getTotalParallelCount(); ++col) {
            for (int row = 0; row < this.geom.getTotalSerialCount(); ++row) {
                int location = this.getRawLocation(segment, row, col);
                int pixval = shortRaw.get(location) & 0xFFFF;
                global.setSegmentSerialParallel(segment, row, col);
                CCDTransform.PixelType type = global.getPixelType();
                if (type == CCDTransform.PixelType.ACTIVE) {
                    pix_sum_active += (double)pixval;
                    pix_sum_sq_active += (double)pixval * (double)pixval;
                    ++npix_active;
                    continue;
                }
                if (type != CCDTransform.PixelType.SERIAL_OVERSCAN) continue;
                pix_sum_bias += (double)pixval;
                pix_sum_sq_bias += (double)pixval * (double)pixval;
                ++npix_bias;
            }
        }
        if (npix_active > 0) {
            double average = pix_sum_active / (double)npix_active;
            double stdev = Math.sqrt(pix_sum_sq_active / (double)npix_active - average * average);
            imageMetaData.put("AVERAGE", average);
            imageMetaData.put("STDEV", stdev);
        }
        if (npix_bias > 0) {
            double average = pix_sum_bias / (double)npix_bias;
            double stdev = Math.sqrt(pix_sum_sq_bias / (double)npix_bias - average * average);
            imageMetaData.put("AVGBIAS", average);
            imageMetaData.put("STDVBIAS", stdev);
        }
    }

    private int getRawLocation(CCDGeometry.CCDSegment segment, int x, int y) {
        int l = 0;
        l += (segment.getCCDGeometry().getSegmentRowCount() - 1 - segment.getRow()) * this.geom.getTotalSerialCount();
        l += segment.getColumn() * this.geom.getTotalParallelCount() * this.geom.getTotalSerialSize();
        if (!segment.getReadout().isDown()) {
            l += this.geom.getTotalSerialCount() - 1;
        }
        if (segment.getReadout().isRight()) {
            l += this.geom.getTotalParallelCount() * this.geom.getTotalSerialSize() - this.geom.getTotalSerialSize();
        }
        l += !segment.getReadout().isDown() ? -x : x;
        assert ((l += this.geom.getTotalSerialSize() * (segment.getReadout().isRight() ? -y : y)) >= 0 && l < this.geom.getTotalSerialSize() * this.geom.getTotalParallelSize());
        return l;
    }

    void pushDataToFile(FitsFileWriter writer) throws IOException {
        long start = System.currentTimeMillis();
        ByteBuffer raw = ByteBuffer.wrap(this.rawImage.getData());
        raw.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer shortRaw = raw.asShortBuffer();
        ByteBuffer dest = ByteBuffer.allocate(1000000);
        dest.order(ByteOrder.BIG_ENDIAN);
        for (CCDGeometry.CCDSegment segment : this.geom.getSegments()) {
            for (int col = 0; col < this.geom.getTotalParallelCount(); ++col) {
                for (int row = 0; row < this.geom.getTotalSerialCount(); ++row) {
                    int location = this.getRawLocation(segment, row, col);
                    dest.putShort((short)(shortRaw.get(location) - 32768));
                    if (dest.hasRemaining()) continue;
                    dest.flip();
                    writer.write(segment.getChannel() - 1, dest);
                    dest.clear();
                }
            }
            dest.flip();
            writer.write(segment.getChannel() - 1, dest);
            dest.clear();
        }
        long stop = System.currentTimeMillis();
        logger.log(Level.FINE, "Wrote image in {0}ms", stop - start);
    }
}

