/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.Bits;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Table;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Reliable unicast layer")
public class UNICAST
extends Protocol
implements AgeOutCache.Handler<Address> {
    public static final long DEFAULT_FIRST_SEQNO = 1L;
    @Deprecated
    protected int[] timeout = new int[]{400, 800, 1600, 3200};
    @Property(description="Max number of messages to be removed from a retransmit window. This property might get removed anytime, so don't use it !")
    protected int max_msg_batch_size = 500;
    @Property(description="Time (in milliseconds) after which an idle incoming or outgoing connection is closed. The connection will get re-established when used again. 0 disables connection reaping")
    protected long conn_expiry_timeout = 0L;
    @Deprecated
    @Property(description="Size (in bytes) of a Segment in the segments table. Only for experts, do not use !", deprecatedMessage="not used anymore")
    protected int segment_capacity = 1000;
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    protected int xmit_table_num_rows = 100;
    @Property(description="Number of elements of a row of the matrix in the retransmission table (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    protected int xmit_table_msgs_per_row = 1000;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    protected double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false)
    protected long xmit_table_max_compaction_time = 600000L;
    protected long max_retransmit_time = 60000L;
    @Property(description="Interval (in milliseconds) at which messages in the send windows are resent")
    protected long xmit_interval = 2000L;
    protected long num_msgs_sent = 0L;
    protected long num_msgs_received = 0L;
    protected long num_acks_sent = 0L;
    protected long num_acks_received = 0L;
    protected long num_xmits = 0L;
    protected final ConcurrentMap<Address, SenderEntry> send_table = Util.createConcurrentMap();
    protected final ConcurrentMap<Address, ReceiverEntry> recv_table = Util.createConcurrentMap();
    protected final ReentrantLock recv_table_lock = new ReentrantLock();
    protected Future<?> xmit_task;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    protected Address local_addr = null;
    protected TimeScheduler timer = null;
    protected volatile boolean running = false;
    protected short last_conn_id = 0;
    protected AgeOutCache<Address> cache = null;
    protected Future<?> connection_reaper;

    public int[] getTimeout() {
        return this.timeout;
    }

    @Deprecated
    @Property(name="timeout", converter=PropertyConverters.IntegerArray.class, deprecatedMessage="not used anymore")
    public void setTimeout(int[] val) {
        if (val != null) {
            this.timeout = val;
        }
    }

    public void setMaxMessageBatchSize(int size) {
        if (size >= 1) {
            this.max_msg_batch_size = size;
        }
    }

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return this.members.toString();
    }

    @ManagedAttribute(description="Whether the ConnectionReaper task is running")
    public boolean isConnectionReaperRunning() {
        return this.connection_reaper != null && !this.connection_reaper.isDone();
    }

    @ManagedAttribute(description="Returns the number of outgoing (send) connections")
    public int getNumSendConnections() {
        return this.send_table.size();
    }

    @ManagedAttribute(description="Returns the number of incoming (receive) connections")
    public int getNumReceiveConnections() {
        return this.recv_table.size();
    }

    @ManagedAttribute(description="Returns the total number of outgoing (send) and incoming (receive) connections")
    public int getNumConnections() {
        return this.getNumReceiveConnections() + this.getNumSendConnections();
    }

    @ManagedOperation
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        if (!this.send_table.isEmpty()) {
            sb.append("\nsend connections:\n");
            for (Map.Entry entry : this.send_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (!this.recv_table.isEmpty()) {
            sb.append("\nreceive connections:\n");
            for (Map.Entry entry : this.recv_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedAttribute
    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    @ManagedAttribute
    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    @ManagedAttribute
    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    @ManagedAttribute
    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    @ManagedAttribute
    public long getNumXmits() {
        return this.num_xmits;
    }

    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    @Property(description="Max number of milliseconds we try to retransmit a message to any given member. After that, the connection is removed. Any new connection to that member will start with seqno #1 again. 0 disables this")
    public void setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
    }

    @ManagedAttribute(description="Is the retransmit task running")
    public boolean isXmitTaskRunning() {
        return this.xmit_task != null && !this.xmit_task.isDone();
    }

    @ManagedAttribute
    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @ManagedOperation
    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache<Address> getAgeOutCache() {
        return this.cache;
    }

    public boolean hasSendConnectionTo(Address dest) {
        return this.send_table.containsKey(dest);
    }

    @ManagedAttribute
    public int getNumUnackedMessages() {
        int num = 0;
        for (SenderEntry entry : this.send_table.values()) {
            if (entry.sent_msgs == null) continue;
            num += entry.sent_msgs.size();
        }
        return num;
    }

    @ManagedAttribute
    public int getNumberOfMessagesInReceiveWindows() {
        int num = 0;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            num += entry.received_msgs.size();
        }
        return num;
    }

    @ManagedAttribute(description="Total number of undelivered messages in all receive windows")
    public long getXmitTableUndeliveredMessages() {
        long retval = 0L;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += (long)entry.received_msgs.size();
        }
        return retval;
    }

    @ManagedAttribute(description="Total number of missing messages in all receive windows")
    public long getXmitTableMissingMessages() {
        long retval = 0L;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            retval += (long)entry.received_msgs.getNumMissing();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of compactions in all (receive and send) windows")
    public int getXmitTableNumCompactions() {
        int retval = 0;
        for (Object entry : this.recv_table.values()) {
            if (((ReceiverEntry)entry).received_msgs == null) continue;
            retval += ((ReceiverEntry)entry).received_msgs.getNumCompactions();
        }
        for (Object entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumCompactions();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of moves in all (receive and send) windows")
    public int getXmitTableNumMoves() {
        int retval = 0;
        for (Object entry : this.recv_table.values()) {
            if (((ReceiverEntry)entry).received_msgs == null) continue;
            retval += ((ReceiverEntry)entry).received_msgs.getNumMoves();
        }
        for (Object entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumMoves();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of resizes in all (receive and send) windows")
    public int getXmitTableNumResizes() {
        int retval = 0;
        for (Object entry : this.recv_table.values()) {
            if (((ReceiverEntry)entry).received_msgs == null) continue;
            retval += ((ReceiverEntry)entry).received_msgs.getNumResizes();
        }
        for (Object entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumResizes();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of purges in all (receive and send) windows")
    public int getXmitTableNumPurges() {
        int retval = 0;
        for (Object entry : this.recv_table.values()) {
            if (((ReceiverEntry)entry).received_msgs == null) continue;
            retval += ((ReceiverEntry)entry).received_msgs.getNumPurges();
        }
        for (Object entry : this.send_table.values()) {
            if (((SenderEntry)entry).sent_msgs == null) continue;
            retval += ((SenderEntry)entry).sent_msgs.getNumPurges();
        }
        return retval;
    }

    @ManagedOperation(description="Prints the contents of the receive windows for all members")
    public String printReceiveWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table<Message> buf = ((ReceiverEntry)entry.getValue()).received_msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @ManagedOperation(description="Prints the contents of the send windows for all members")
    public String printSendWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.send_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table<Message> buf = ((SenderEntry)entry.getValue()).sent_msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @Override
    public void resetStats() {
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_xmits = 0L;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("num_unacked_msgs", this.getNumUnackedMessages());
        m.put("num_msgs_in_recv_windows", this.getNumberOfMessagesInReceiveWindows());
        return m;
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.running = true;
        if (this.conn_expiry_timeout > 0L) {
            this.startConnectionReaper();
        }
        this.startRetransmitTask();
    }

    @Override
    public void stop() {
        this.running = false;
        this.stopRetransmitTask();
        this.stopConnectionReaper();
        this.removeAllConnections();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                if (msg.getDest() == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (UnicastHeader)msg.getHeader(this.id)) == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(sender, hdr.seqno, hdr.conn_id, hdr.first, msg, evt);
                        break;
                    }
                    default: {
                        this.handleUpEvent(sender, hdr);
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleUpEvent(Address sender, UnicastHeader hdr) {
        switch (hdr.type) {
            case 0: {
                throw new IllegalStateException("header of type DATA is not supposed to be handled by this method");
            }
            case 1: {
                this.handleAckReceived(sender, hdr.seqno, hdr.conn_id);
                break;
            }
            case 2: {
                this.handleResendingOfFirstMessage(sender, hdr.seqno);
                break;
            }
            default: {
                this.log.error("UnicastHeader type " + hdr.type + " not known !");
            }
        }
    }

    @Override
    public void up(MessageBatch batch) {
        if (batch.dest() == null) {
            this.up_prot.up(batch);
            return;
        }
        int size = batch.size();
        TreeMap<Short, List<Message>> msgs = new TreeMap<Short, List<Message>>();
        for (Message msg : batch) {
            UnicastHeader hdr;
            if (msg == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (UnicastHeader)msg.getHeader(this.id)) == null) continue;
            batch.remove(msg);
            if (hdr.type != 0) {
                try {
                    this.handleUpEvent(msg.getSrc(), hdr);
                }
                catch (Throwable t) {
                    this.log.error(this.local_addr + ": failed handling event", t);
                }
                continue;
            }
            ArrayList<Message> list = (ArrayList<Message>)msgs.get(hdr.conn_id);
            if (list == null) {
                list = new ArrayList<Message>(size);
                msgs.put(hdr.conn_id, list);
            }
            list.add(msg);
        }
        if (!msgs.isEmpty()) {
            this.handleBatchReceived(batch.sender(), msgs);
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY)) break;
                if (!this.running) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("discarded message as start() has not yet been called, message: " + msg);
                    }
                    return null;
                }
                SenderEntry entry = (SenderEntry)this.send_table.get(dst);
                if (entry == null) {
                    entry = new SenderEntry(this.getNewConnectionId());
                    SenderEntry existing = this.send_table.putIfAbsent(dst, entry);
                    if (existing != null) {
                        entry = existing;
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": created sender window for " + dst + " (conn-id=" + entry.send_conn_id + ")");
                        }
                        if (this.cache != null && !this.members.contains(dst)) {
                            this.cache.add(dst);
                        }
                    }
                }
                short send_conn_id = entry.send_conn_id;
                long seqno = entry.sent_msgs_seqno.getAndIncrement();
                long sleep = 10L;
                while (true) {
                    try {
                        msg.putHeader(this.id, UnicastHeader.createDataHeader(seqno, send_conn_id, seqno == 1L));
                        entry.sent_msgs.add(seqno, msg);
                        if (this.conn_expiry_timeout <= 0L) break;
                        entry.update();
                    }
                    catch (Throwable t) {
                        if (!this.running) break;
                        Util.sleep(sleep);
                        sleep = Math.min(5000L, sleep * 2L);
                        if (this.running) continue;
                    }
                    break;
                }
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno).append(", conn_id=").append(send_conn_id);
                    if (seqno == 1L) {
                        sb.append(", first");
                    }
                    sb.append(')');
                    this.log.trace(sb);
                }
                ++this.num_msgs_sent;
                return this.down_prot.down(evt);
            }
            case 6: {
                View view = (View)evt.getArg();
                List<Address> new_members = view.getMembers();
                HashSet non_members = new HashSet(this.send_table.keySet());
                non_members.addAll(this.recv_table.keySet());
                this.members = new_members;
                non_members.removeAll(new_members);
                if (this.cache != null) {
                    this.cache.removeAll(new_members);
                }
                if (non_members.isEmpty()) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("removing non members " + non_members);
                }
                for (Address non_mbr : non_members) {
                    this.removeConnection(non_mbr);
                }
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    public void removeConnection(Address mbr) {
        this.removeSendConnection(mbr);
        this.removeReceiveConnection(mbr);
    }

    public void removeSendConnection(Address mbr) {
        this.send_table.remove(mbr);
    }

    public void removeReceiveConnection(Address mbr) {
        this.recv_table.remove(mbr);
    }

    @ManagedOperation(description="Trashes all connections to other nodes. This is only used for testing")
    public void removeAllConnections() {
        this.send_table.clear();
        this.recv_table.clear();
    }

    public void retransmit(Message msg) {
        if (this.log.isTraceEnabled()) {
            UnicastHeader hdr = (UnicastHeader)msg.getHeader(this.id);
            long seqno = hdr != null ? hdr.seqno : -1L;
            this.log.trace(this.local_addr + " --> XMIT(" + msg.getDest() + ": #" + seqno + ')');
        }
        this.down_prot.down(new Event(1, msg));
        ++this.num_xmits;
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("removing connection to " + key + " because it expired");
            }
            this.removeConnection(key);
        }
    }

    protected void handleDataReceived(Address sender, long seqno, short conn_id, boolean first, Message msg, Event evt) {
        AtomicBoolean processing;
        ReceiverEntry entry;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" <-- DATA(").append(sender).append(": #").append(seqno);
            if (conn_id != 0) {
                sb.append(", conn_id=").append(conn_id);
            }
            if (first) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        if ((entry = this.getReceiverEntry(sender, seqno, first, conn_id)) == null) {
            return;
        }
        if (this.conn_expiry_timeout > 0L) {
            entry.update();
        }
        Table<Message> win = entry.received_msgs;
        boolean added = win.add(seqno, msg);
        ++this.num_msgs_received;
        if (msg.isFlagSet(Message.Flag.OOB) && added) {
            try {
                this.up_prot.up(evt);
            }
            catch (Throwable t) {
                this.log.error("couldn't deliver OOB message " + msg, t);
            }
        }
        if (!(processing = win.getProcessing()).compareAndSet(false, true)) {
            return;
        }
        this.removeAndDeliver(processing, win, sender);
        this.sendAck(sender, win.getHighestDelivered(), conn_id);
    }

    protected void handleBatchReceived(Address sender, Map<Short, List<Message>> map) {
        AtomicBoolean processing;
        Table<Message> win;
        for (Map.Entry<Short, List<Message>> element : map.entrySet()) {
            List<Message> msg_list = element.getValue();
            if (this.log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.local_addr).append(" <-- DATA(").append(sender).append(": " + this.printMessageList(msg_list)).append(')');
                this.log.trace(sb);
            }
            short conn_id = element.getKey();
            ReceiverEntry entry = null;
            for (Message msg : msg_list) {
                UnicastHeader hdr = (UnicastHeader)msg.getHeader(this.id);
                entry = this.getReceiverEntry(sender, hdr.seqno, hdr.first, conn_id);
                if (entry == null) continue;
                Table<Message> win2 = entry.received_msgs;
                boolean msg_added = win2.add(hdr.seqno, msg);
                ++this.num_msgs_received;
                if (hdr.first && msg_added) {
                    this.sendAck(sender, hdr.seqno, conn_id);
                }
                if (!msg.isFlagSet(Message.Flag.OOB) || !msg_added) continue;
                try {
                    this.up_prot.up(new Event(1, msg));
                }
                catch (Throwable t) {
                    this.log.error("couldn't deliver OOB message " + msg, t);
                }
            }
            if (entry == null || this.conn_expiry_timeout <= 0L) continue;
            entry.update();
        }
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
        Table<Message> table = win = entry != null ? entry.received_msgs : null;
        if (win != null && (processing = win.getProcessing()).compareAndSet(false, true)) {
            this.removeAndDeliver(processing, win, sender);
            this.sendAck(sender, win.getHighestDeliverable(), entry.recv_conn_id);
        }
    }

    protected int removeAndDeliver(AtomicBoolean processing, Table<Message> win, Address sender) {
        int retval = 0;
        boolean released_processing = false;
        try {
            while (true) {
                List<Message> list;
                if ((list = win.removeMany(processing, true, this.max_msg_batch_size)) == null) {
                    released_processing = true;
                    int n = retval;
                    return n;
                }
                MessageBatch batch = new MessageBatch(this.local_addr, sender, null, false, list);
                for (Message msg_to_deliver : batch) {
                    if (!msg_to_deliver.isFlagSet(Message.Flag.OOB)) continue;
                    batch.remove(msg_to_deliver);
                }
                try {
                    if (this.log.isTraceEnabled()) {
                        Message first = batch.first();
                        Message last = batch.last();
                        StringBuilder sb = new StringBuilder(this.local_addr + ": delivering");
                        if (first != null && last != null) {
                            UnicastHeader hdr1 = (UnicastHeader)first.getHeader(this.id);
                            UnicastHeader hdr2 = (UnicastHeader)last.getHeader(this.id);
                            sb.append(" #").append(hdr1.seqno).append(" - #").append(hdr2.seqno);
                        }
                        sb.append(" (" + batch.size()).append(" messages)");
                        this.log.trace(sb);
                    }
                    this.up_prot.up(batch);
                }
                catch (Throwable t) {
                    this.log.error("failed to deliver batch " + batch, t);
                }
            }
        }
        finally {
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReceiverEntry getReceiverEntry(Address sender, long seqno, boolean first, short conn_id) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
        if (entry != null && entry.recv_conn_id == conn_id) {
            return entry;
        }
        this.recv_table_lock.lock();
        try {
            entry = (ReceiverEntry)this.recv_table.get(sender);
            if (first) {
                if (entry == null) {
                    entry = this.getOrCreateReceiverEntry(sender, seqno, conn_id);
                } else if (conn_id != entry.recv_conn_id) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": conn_id=" + conn_id + " != " + entry.recv_conn_id + "; resetting receiver window");
                    }
                    this.recv_table.remove(sender);
                    entry = this.getOrCreateReceiverEntry(sender, seqno, conn_id);
                }
            } else if (entry == null || entry.recv_conn_id != conn_id) {
                this.recv_table_lock.unlock();
                this.sendRequestForFirstSeqno(sender, seqno);
                ReceiverEntry receiverEntry = null;
                return receiverEntry;
            }
            ReceiverEntry receiverEntry = entry;
            return receiverEntry;
        }
        finally {
            if (this.recv_table_lock.isHeldByCurrentThread()) {
                this.recv_table_lock.unlock();
            }
        }
    }

    protected ReceiverEntry getOrCreateReceiverEntry(Address sender, long seqno, short conn_id) {
        Table<Message> table = new Table<Message>(this.xmit_table_num_rows, this.xmit_table_msgs_per_row, seqno - 1L, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time);
        ReceiverEntry entry = new ReceiverEntry(table, conn_id);
        ReceiverEntry entry2 = this.recv_table.putIfAbsent(sender, entry);
        if (entry2 != null) {
            return entry2;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": created receiver window for " + sender + " at seqno=#" + seqno + " for conn-id=" + conn_id);
        }
        return entry;
    }

    protected void handleAckReceived(Address sender, long seqno, short conn_id) {
        Table<Message> win;
        SenderEntry entry;
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" <-- ACK(").append(sender).append(": #").append(seqno).append(", conn-id=").append(conn_id).append(')'));
        }
        if ((entry = (SenderEntry)this.send_table.get(sender)) != null && entry.send_conn_id != conn_id) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": my conn_id (" + entry.send_conn_id + ") != received conn_id (" + conn_id + "); discarding ACK");
            }
            return;
        }
        Table<Message> table = win = entry != null ? entry.sent_msgs : null;
        if (win != null) {
            win.purge(seqno, true);
            ++this.num_acks_received;
        }
    }

    protected void handleResendingOfFirstMessage(Address sender, long seqno) {
        SenderEntry entry;
        Table<Message> win;
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " <-- SEND_FIRST_SEQNO(" + sender + "," + seqno + ")");
        }
        Table<Message> table = win = (entry = (SenderEntry)this.send_table.get(sender)) != null ? entry.sent_msgs : null;
        if (win == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(this.local_addr + ": sender window for " + sender + " not found");
            }
            return;
        }
        boolean first_sent = false;
        for (long i = win.getLow() + 1L; i <= seqno; ++i) {
            Message rsp = win.get(i);
            if (rsp == null) continue;
            if (first_sent) {
                this.down_prot.down(new Event(1, rsp));
                continue;
            }
            first_sent = true;
            Message copy = rsp.copy();
            UnicastHeader hdr = (UnicastHeader)copy.getHeader(this.id);
            UnicastHeader newhdr = hdr.copy();
            newhdr.first = true;
            copy.putHeader(this.id, newhdr);
            this.down_prot.down(new Event(1, copy));
        }
    }

    protected void startRetransmitTask() {
        if (this.xmit_task == null || this.xmit_task.isDone()) {
            this.xmit_task = this.timer.scheduleWithFixedDelay(new RetransmitTask(), 0L, this.xmit_interval, TimeUnit.MILLISECONDS);
        }
    }

    protected void stopRetransmitTask() {
        if (this.xmit_task != null) {
            this.xmit_task.cancel(true);
            this.xmit_task = null;
        }
    }

    protected void sendAck(Address dst, long seqno, short conn_id) {
        if (!this.running) {
            return;
        }
        Message ack = new Message(dst).setFlag(Message.Flag.INTERNAL).putHeader(this.id, UnicastHeader.createAckHeader(seqno, conn_id));
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" --> ACK(").append(dst).append(": #").append(seqno).append(')'));
        }
        try {
            this.down_prot.down(new Event(1, ack));
            ++this.num_acks_sent;
        }
        catch (Throwable t) {
            this.log.error("failed sending ACK(" + seqno + ") to " + dst, t);
        }
    }

    protected synchronized void startConnectionReaper() {
        if (this.connection_reaper == null || this.connection_reaper.isDone()) {
            this.connection_reaper = this.timer.scheduleWithFixedDelay(new ConnectionReaper(), this.conn_expiry_timeout, this.conn_expiry_timeout, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopConnectionReaper() {
        if (this.connection_reaper != null) {
            this.connection_reaper.cancel(false);
        }
    }

    protected synchronized short getNewConnectionId() {
        short retval = this.last_conn_id;
        this.last_conn_id = this.last_conn_id >= Short.MAX_VALUE || this.last_conn_id < 0 ? (short)0 : (short)(this.last_conn_id + 1);
        return retval;
    }

    protected void sendRequestForFirstSeqno(Address dest, long seqno_received) {
        Message msg = new Message(dest).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
        UnicastHeader hdr = UnicastHeader.createSendFirstSeqnoHeader(seqno_received);
        msg.putHeader(this.id, hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " --> SEND_FIRST_SEQNO(" + dest + "," + seqno_received + ")");
        }
        this.down_prot.down(new Event(1, msg));
    }

    @ManagedOperation(description="Closes connections that have been idle for more than conn_expiry_timeout ms")
    public void reapIdleConnections() {
        long age;
        Object val;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            age = ((SenderEntry)val).age();
            if (age < this.conn_expiry_timeout) continue;
            this.removeSendConnection((Address)entry.getKey());
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(this.local_addr + ": removed expired connection for " + entry.getKey() + " (" + age + " ms old) from send_table");
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            age = ((ReceiverEntry)val).age();
            if (age < this.conn_expiry_timeout) continue;
            this.removeReceiveConnection((Address)entry.getKey());
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(this.local_addr + ": removed expired connection for " + entry.getKey() + " (" + age + " ms old) from recv_table");
        }
    }

    protected String printMessageList(List<Message> list) {
        UnicastHeader hdr;
        Message second;
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        Message first = size > 0 ? list.get(0) : null;
        Message message = second = size > 1 ? list.get(size - 1) : first;
        if (first != null && (hdr = (UnicastHeader)first.getHeader(this.id)) != null) {
            sb.append("#" + hdr.seqno);
        }
        if (second != null && (hdr = (UnicastHeader)second.getHeader(this.id)) != null) {
            sb.append(" - #" + hdr.seqno);
        }
        return sb.toString();
    }

    protected class RetransmitTask
    implements Runnable {
        protected RetransmitTask() {
        }

        @Override
        public void run() {
            for (SenderEntry val : UNICAST.this.send_table.values()) {
                long to;
                long from;
                List<Message> list;
                Table<Message> buf = val != null ? val.sent_msgs : null;
                if (buf == null || buf.isEmpty() || (list = buf.get(from = buf.getHighestDelivered() + 1L, to = buf.getHighestReceived())) == null) continue;
                for (Message msg : list) {
                    UNICAST.this.retransmit(msg);
                }
            }
        }

        public String toString() {
            return UNICAST.class.getSimpleName() + ": RetransmitTask (interval=" + UNICAST.this.xmit_interval + " ms)";
        }
    }

    protected class ConnectionReaper
    implements Runnable {
        protected ConnectionReaper() {
        }

        @Override
        public void run() {
            UNICAST.this.reapIdleConnections();
        }

        public String toString() {
            return UNICAST.class.getSimpleName() + ": ConnectionReaper (interval=" + UNICAST.this.conn_expiry_timeout + " ms)";
        }
    }

    protected static final class ReceiverEntry {
        protected final Table<Message> received_msgs;
        protected final short recv_conn_id;
        protected final AtomicLong timestamp = new AtomicLong(0L);

        public ReceiverEntry(Table<Message> received_msgs, short recv_conn_id) {
            this.received_msgs = received_msgs;
            this.recv_conn_id = recv_conn_id;
            this.update();
        }

        void update() {
            this.timestamp.set(System.currentTimeMillis());
        }

        long age() {
            return System.currentTimeMillis() - this.timestamp.longValue();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.received_msgs != null) {
                sb.append(this.received_msgs).append(", ");
            }
            sb.append("recv_conn_id=" + this.recv_conn_id);
            sb.append(" (" + this.age() + " ms old)");
            return sb.toString();
        }
    }

    protected final class SenderEntry {
        final Table<Message> sent_msgs;
        final AtomicLong sent_msgs_seqno = new AtomicLong(1L);
        final short send_conn_id;
        protected final AtomicLong timestamp = new AtomicLong(0L);
        final Lock lock = new ReentrantLock();

        public SenderEntry(short send_conn_id) {
            this.send_conn_id = send_conn_id;
            this.sent_msgs = new Table(UNICAST.this.xmit_table_num_rows, UNICAST.this.xmit_table_msgs_per_row, 0L, UNICAST.this.xmit_table_resize_factor, UNICAST.this.xmit_table_max_compaction_time);
            this.update();
        }

        void update() {
            this.timestamp.set(System.currentTimeMillis());
        }

        long age() {
            return System.currentTimeMillis() - this.timestamp.longValue();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.sent_msgs != null) {
                sb.append(this.sent_msgs).append(", ");
            }
            sb.append("send_conn_id=" + this.send_conn_id).append(" (" + this.age() + " ms old)");
            return sb.toString();
        }
    }

    public static class UnicastHeader
    extends Header {
        public static final byte DATA = 0;
        public static final byte ACK = 1;
        public static final byte SEND_FIRST_SEQNO = 2;
        byte type;
        long seqno;
        short conn_id;
        boolean first;

        public UnicastHeader() {
        }

        public static UnicastHeader createDataHeader(long seqno, short conn_id, boolean first) {
            return new UnicastHeader(0, seqno, conn_id, first);
        }

        public static UnicastHeader createAckHeader(long seqno, short conn_id) {
            return new UnicastHeader(1, seqno, conn_id, false);
        }

        public static UnicastHeader createSendFirstSeqnoHeader(long seqno_received) {
            return new UnicastHeader(2, seqno_received);
        }

        protected UnicastHeader(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        protected UnicastHeader(byte type, long seqno, short conn_id, boolean first) {
            this.type = type;
            this.seqno = seqno;
            this.conn_id = conn_id;
            this.first = first;
        }

        public long getSeqno() {
            return this.seqno;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(UnicastHeader.type2Str(this.type)).append(", seqno=").append(this.seqno);
            if (this.conn_id != 0) {
                sb.append(", conn_id=").append(this.conn_id);
            }
            if (this.first) {
                sb.append(", first");
            }
            return sb.toString();
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "ACK";
                }
                case 2: {
                    return "SEND_FIRST_SEQNO";
                }
            }
            return "<unknown>";
        }

        @Override
        public final int size() {
            int retval = 1;
            switch (this.type) {
                case 0: {
                    retval += Bits.size(this.seqno) + 2 + 1;
                    break;
                }
                case 1: {
                    retval += Bits.size(this.seqno) + 2;
                    break;
                }
                case 2: {
                    retval += Bits.size(this.seqno);
                }
            }
            return retval;
        }

        public UnicastHeader copy() {
            return new UnicastHeader(this.type, this.seqno, this.conn_id, this.first);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            switch (this.type) {
                case 0: {
                    Bits.writeLong(this.seqno, out);
                    out.writeShort(this.conn_id);
                    out.writeBoolean(this.first);
                    break;
                }
                case 1: {
                    Bits.writeLong(this.seqno, out);
                    out.writeShort(this.conn_id);
                    break;
                }
                case 2: {
                    Bits.writeLong(this.seqno, out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            switch (this.type) {
                case 0: {
                    this.seqno = Bits.readLong(in);
                    this.conn_id = in.readShort();
                    this.first = in.readBoolean();
                    break;
                }
                case 1: {
                    this.seqno = Bits.readLong(in);
                    this.conn_id = in.readShort();
                    break;
                }
                case 2: {
                    this.seqno = Bits.readLong(in);
                }
            }
        }
    }
}

