/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.image.FitsCheckSum;

public class FitsUtilities {
    List<PDValue> readPhotoDiodeFile(File fileName) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            String line;
            ArrayList<PDValue> result = new ArrayList<PDValue>();
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split(" ");
                double time = Double.parseDouble(tokens[0]);
                double value = Double.parseDouble(tokens[1]);
                result.add(new PDValue(time, value));
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    double analyzePhotoDiodeValues(List<PDValue> pddata) {
        double pdsum = 0.0;
        for (PDValue data : pddata) {
            pdsum += data.getValue();
        }
        double pdavg_all = pdsum / (double)pddata.size();
        System.out.println("Average of all PD values is " + pdavg_all);
        pdsum = 0.0;
        int nelem = 0;
        for (PDValue data : pddata) {
            double pdval = data.getValue();
            if (!(Math.abs(pdval) > Math.abs(pdavg_all))) continue;
            pdsum += pdval;
            ++nelem;
        }
        double pdavg_expo = pdsum / (double)nelem;
        System.out.println("Number elements in luminous curve region = " + nelem);
        System.out.println("Sum of PD values in luminous region = " + pdsum);
        System.out.println("PD average value during exposure = " + pdavg_expo);
        return pdavg_expo / 1.0E-9;
    }

    private BinaryTableHDU createPhotoDiodeHDU(List<PDValue> data, String extnam, String c1name, String c2name, double tstart) throws FitsException {
        BinaryTable binTable = new BinaryTable();
        double[] times = new double[data.size()];
        double[] values = new double[data.size()];
        int i = 0;
        for (PDValue datum : data) {
            times[i] = datum.getTime();
            values[i] = datum.getValue();
            ++i;
        }
        binTable.addColumn((Object)times);
        binTable.addColumn((Object)values);
        Header header = new Header((Data)binTable);
        header.addValue("EXTNAME", extnam, "Name of the extension");
        header.addValue("TSTART", tstart, "Time of Start of Readings");
        BinaryTableHDU bhdu = new BinaryTableHDU(header, binTable);
        bhdu.setColumnName(0, c1name, "time");
        bhdu.setColumnName(1, c2name, "values");
        bhdu.info(System.out);
        return bhdu;
    }

    public void updatePhotoDiodeValues(File pddatfile, File fitsfile, String extnam, String c1name, String c2name, double tstart) throws IOException, FitsException {
        List<PDValue> data = this.readPhotoDiodeFile(pddatfile);
        double pdavg_expo = this.analyzePhotoDiodeValues(data);
        BinaryTableHDU bhdu = this.createPhotoDiodeHDU(data, extnam, c1name, c2name, tstart);
        File tmpName = File.createTempFile("tmp", "fits", fitsfile.getParentFile());
        Throwable throwable = null;
        Object var14_13 = null;
        try (Fits in = new Fits(fitsfile);){
            Throwable throwable2 = null;
            Object var17_18 = null;
            try (BufferedFile out = new BufferedFile(tmpName, "rw");){
                in.read();
                BasicHDU primary = in.getHDU(0);
                if (primary.getHeader().containsKey("MONDIODE")) {
                    primary.getHeader().deleteKey("MONDIODE");
                }
                primary.getHeader().addValue("MONDIODE", pdavg_expo, "avg PD value (nA) during expo");
                FitsCheckSum.setChecksum((BasicHDU)primary);
                primary.write((ArrayDataOutput)out);
                int ihdu = 1;
                while (ihdu < in.getNumberOfHDUs()) {
                    BasicHDU hdu = in.getHDU(ihdu);
                    String extn = hdu.getHeader().getStringValue("EXTNAME");
                    if (!extn.equals(extnam)) {
                        hdu.write((ArrayDataOutput)out);
                    }
                    ++ihdu;
                }
                FitsCheckSum.setChecksum((BasicHDU)bhdu);
                bhdu.write((ArrayDataOutput)out);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        Files.move(tmpName.toPath(), fitsfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public double getFluxStats(File fitsfile) throws FitsException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Fits fits = new Fits(fitsfile);){
            double minflux = Double.MAX_VALUE;
            double fluxsum = 0.0;
            int fluxentries = 0;
            fits.read();
            Header primary = fits.getHDU(0).getHeader();
            double gain = primary.getDoubleValue("CCDGAIN");
            double exptime = fits.getHDU(0).getHeader().getDoubleValue("EXPTIME");
            int ihdu = 1;
            while (ihdu < fits.getNumberOfHDUs()) {
                Header extension = fits.getHDU(ihdu).getHeader();
                String extn = extension.getStringValue("EXTNAME");
                if (extn.contains("Segment")) {
                    double avg = fits.getHDU(ihdu).getHeader().getDoubleValue("AVERAGE");
                    double bias = fits.getHDU(ihdu).getHeader().getDoubleValue("AVGBIAS");
                    double signal = (avg - bias) * gain;
                    double flux = Math.max(signal / exptime, 1.0);
                    minflux = Math.min(minflux, flux);
                    fluxsum += flux;
                    fluxentries = (int)((double)fluxentries + 1.0);
                    System.out.println(String.valueOf(extn) + " signal = " + signal + " exptime = " + exptime + " flux = " + flux + " minflux for CCD = " + minflux);
                }
                ++ihdu;
            }
            return fluxsum / (double)fluxentries;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static class PDValue {
        private double time;
        private double value;

        private PDValue(double time, double value) {
            this.time = time;
            this.value = value;
        }

        public double getTime() {
            return this.time;
        }

        public double getValue() {
            return this.value;
        }
    }
}

