/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import nom.tam.fits.FitsException;
import org.astrogrid.samp.client.SampException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusAggregator;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.archon.ArchonController;
import org.lsst.ccs.drivers.archon.ArchonControllerDriver;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.drivers.archon.DummyArchonController;
import org.lsst.ccs.drivers.archon.RawImageData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystem.archon.FitsUtilities;
import org.lsst.ccs.subsystem.archon.ImageHandler;
import org.lsst.ccs.subsystem.archon.RawImageConverter;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.archon.data.ArchonControllerStatus;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.image.samp.SampUtils;

public class Archon
extends Module {
    private final ArchonController ctl;
    private ArchonConfiguration cf;
    private final StatusAggregator sa = new StatusAggregator();
    private final FitsUtilities fitsUtils = new FitsUtilities();
    private String fitsDirectory = ".";
    private String fitsFileName = "ArchonImageFile_${timestamp}.fits";
    private ImageHandler imageHandler;
    private Properties headerProperties;
    private final Map<String, Object> headerOverides = new HashMap<String, Object>();
    private boolean sendImagesToDS9 = false;
    private SampUtils su;
    private double imageAverageSignal = 0.0;
    private CCDType defaultCCDType;
    private long fetch_timeout = 200000L;
    private String acqParam = "ACQ";
    private String lastTestType;
    private String configFileName;
    private String fitsCCDnum = "";
    int modifiedModuleMask = 0;
    volatile boolean inExposure = false;
    volatile boolean inExposureSeries = false;

    public Archon(String name, int tickMillis, String ip) {
        super(name, tickMillis);
        try {
            this.ctl = ip == null ? new DummyArchonController() : new ArchonControllerDriver(ip);
        }
        catch (DriverException e) {
            throw new RuntimeException(e);
        }
    }

    public void initModule() {
        MessagingFactory.getInstance().forSubsystem("archon-sl").addStatusListener((StatusListens)this.sa);
        this.imageHandler = new ImageHandler();
        for (HeaderSpecification spc : this.imageHandler.getConfig().values()) {
            for (HeaderSpecification.HeaderLine l : spc.getHeaders()) {
                String meta = l.getMetaName();
                if (meta == null || !meta.contains("/")) continue;
                log.info((Object)("adding " + meta + " to agregator"), new String[0]);
                this.sa.setAggregate(meta, -1, -1);
            }
        }
        this.headerProperties = BootstrapResourceUtils.getBootstrapProperties((String)"header.properties");
    }

    public void shutdownNow() {
        MessagingFactory.getInstance().forSubsystem("archon-sl").shutdownBusAccess();
        super.shutdownNow();
    }

    public void tick() {
        if (this.inExposureSeries) {
            return;
        }
        ArchonControllerStatus st = this.getControllerStatus();
        log.info((Object)("sending status, backplane temp = " + st.getBackplaneTemp()), new String[0]);
        this.publish("archonControllerStatus", st);
        Status s = new Status();
        s.setSummary("archon tick");
        this.getSubsystem().broadcastStatus(s);
    }

    @Command
    public void setConfigFromFile(String fn) {
        try {
            this.cf = new ArchonConfiguration(fn);
            log.info((Object)"config read", new String[0]);
            Status s = new Status();
            s.setSummary("config read");
            this.getSubsystem().broadcastStatus(s);
            this.configFileName = fn;
        }
        catch (IOException e) {
            log.error((Object)"error reading config", (Throwable)e, new String[0]);
        }
    }

    @Command
    public void setAndApplyConfig(ArchonConfiguration c) {
        this.setConfig(c);
        this.applyConfig();
    }

    @Command
    public void setAndApplyParams(ArchonConfiguration c) {
        this.setConfig(c);
        this.applyParams();
    }

    @Command
    public CCDType getDefaultCCDType() {
        return this.defaultCCDType;
    }

    @Command
    public void setDefaultCCDType(CCDType ccdType) {
        this.defaultCCDType = ccdType;
    }

    @Command
    public void setDefaultCCDTypeName(String ccdType) {
        this.defaultCCDType = CCDType.valueOf((String)ccdType);
    }

    @Command
    public CCDType getCCDType() {
        if (this.defaultCCDType == null) {
            if (this.cf != null) {
                String parameter = this.cf.getParameter("CCDType");
                if ("1".equals(parameter)) {
                    return CCDType.ITL;
                }
                return CCDType.E2V;
            }
            return CCDType.E2V;
        }
        return this.defaultCCDType;
    }

    @Command
    public void setConfig(ArchonConfiguration c) {
        this.cf = c;
        log.info((Object)"config updated", new String[0]);
        Status s = new Status();
        s.setSummary("config updated");
        this.getSubsystem().broadcastStatus(s);
    }

    @Command
    public void addBinaryTable(String pddatfile, String fitsfile, String extnam, String c1name, String c2name, double tstart) throws IOException, FitsException {
        this.fitsUtils.updatePhotoDiodeValues(new File(pddatfile), new File(fitsfile), extnam, c1name, c2name, tstart);
    }

    @Command
    public double getFluxStats(String fitsfile) throws FitsException, IOException {
        return this.fitsUtils.getFluxStats(new File(fitsfile));
    }

    @Command
    public void setAcqParam(String acqParam) {
        this.acqParam = acqParam;
    }

    public String getAcqParam() {
        return this.acqParam;
    }

    @Command(description="Get the archon controller status")
    public ArchonControllerStatus getControllerStatus() {
        log.info((Object)"get controller status", new String[0]);
        return this.buildStatus();
    }

    @Command(description="Test if images will be sent to DS9 automatically")
    public boolean isSendImagesToDS9() {
        return this.sendImagesToDS9;
    }

    @Command(description="Set if images should be sent to DS9 automatically")
    public void setSendImagesToDS9(boolean sendImagesToDS9) {
        this.sendImagesToDS9 = sendImagesToDS9;
    }

    private ArchonControllerStatus buildStatus() {
        try {
            ArchonStatus s = this.ctl.getStatus();
            ArchonControllerStatus acs = new ArchonControllerStatus();
            this.copySimpleFields(s, acs);
            ArchonControllerStatus.ArchonBoardStatus[] abs = new ArchonControllerStatus.ArchonBoardStatus[12];
            int i = 0;
            while (i < s.boards.length) {
                ArchonStatus.BoardStatus bs;
                block23: {
                    bs = s.boards[i];
                    if (bs == null) break block23;
                    switch (bs.getClass().getSimpleName()) {
                        case "ADStatus": {
                            abs[i] = new ArchonControllerStatus.ArchonADBoardStatus();
                            break;
                        }
                        case "DriverStatus": {
                            abs[i] = new ArchonControllerStatus.ArchonDriverBoardStatus();
                            break;
                        }
                        case "HeaterStatus": {
                            abs[i] = new ArchonControllerStatus.ArchonHeaterBoardStatus();
                            break;
                        }
                        case "HVBiasStatus": {
                            abs[i] = new ArchonControllerStatus.ArchonHVBiasBoardStatus();
                            break;
                        }
                        case "LVBiasStatus": {
                            abs[i] = new ArchonControllerStatus.ArchonLVBiasBoardStatus();
                        }
                    }
                }
                if (abs[i] != null) {
                    this.copySimpleFields(bs, abs[i]);
                }
                ++i;
            }
            Field f = ArchonControllerStatus.class.getDeclaredField("boards");
            f.setAccessible(true);
            f.set(acs, abs);
            return acs;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException | DriverException e) {
            log.error((Object)"error getting status", e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    private void copySimpleFields(Object source, Class srcClass, Object dest, Class destClass) {
        Field[] fieldArray = srcClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                Field df = destClass.getDeclaredField(f.getName());
                if (df != null) {
                    log.debug((Object)("copying " + f.getName()), new String[0]);
                    df.setAccessible(true);
                    df.set(dest, f.get(source));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
            ++n2;
        }
    }

    private void copySimpleFields(Object source, Object dest) {
        Class<?> srcClass = source.getClass();
        Class<?> destClass = dest.getClass();
        do {
            this.copySimpleFields(source, srcClass, dest, destClass);
            srcClass = srcClass.getSuperclass();
            destClass = destClass.getSuperclass();
        } while (srcClass != null && destClass != null);
    }

    @Command(description="Set an archon configuration parameter. Requires applyParams of applyConfig after.")
    public void setParameter(String name, String value) {
        if (this.cf == null) {
            throw new IllegalArgumentException("cannot set parameter without having defined a configuration from an acf file ");
        }
        this.cf.setParameter(name, value);
    }

    @Command(description="Set an archon configuration parameter and applies the one line change.")
    public void setAndApplyParam(String name, String value) throws DriverException {
        if (this.cf == null) {
            throw new IllegalArgumentException("cannot set parameter without having defined a configuration from an acf file ");
        }
        int iline = this.cf.setParameter(name, value);
        System.out.println("writing to line " + iline + ":\n" + this.cf.getLine(iline));
        this.ctl.writeConfigLine(iline, this.cf.getLine(iline));
        System.out.println("loading parameter " + this.cf.getLine(iline).split("=")[1]);
        this.ctl.loadParam(this.cf.getLine(iline).split("=")[1]);
    }

    @Command(description="Get an archon configuration parameter")
    public String getParameter(String name) {
        return this.cf.getParameter(name);
    }

    @Command(description="Set an archon configuration constant. Requires applyTiming of applyConfig after.")
    public void setConstant(String name, String value) {
        if (this.cf == null) {
            throw new IllegalArgumentException("cannot set constant without having defined a configuration from an acf file ");
        }
        this.cf.setConstant(name, value);
    }

    @Command(description="Get an archon configuration constant")
    public String getConstant(String name) {
        return this.cf.getConstant(name);
    }

    @Command(description="Set an archon configuration labeled value. Requires applyLabed or applyConfig after.")
    public void setLabeled(String name, String value) {
        if (this.cf == null) {
            throw new IllegalArgumentException("cannot set constant without having defined a configuration from an acf file ");
        }
        int i = this.cf.setLabeled(name, value);
        this.modifiedModuleMask |= 1 << i;
    }

    @Command(description="Get current labeled value")
    public String getLabeled(String name) {
        return this.cf.getLabeled(name);
    }

    @Command(description="Updates archon configuration with new labeled values")
    public void applyLabeled() {
        try {
            log.info((Object)"sending configuration to controller", new String[0]);
            this.ctl.writeConfigLines(this.cf.getLines());
            int i = 0;
            while (i < 16) {
                if ((this.modifiedModuleMask & 1 << i) != 0) {
                    log.info((Object)("applying module config " + i), new String[0]);
                    this.ctl.applyMod(i);
                }
                ++i;
            }
            this.modifiedModuleMask = 0;
        }
        catch (DriverException e) {
            log.error((Object)"error sending config", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="Override a FITS header")
    public void setHeader(@Argument(name="name") String name, @Argument(name="value", defaultValue="") Object value) {
        if (value == null || value.toString().isEmpty()) {
            this.headerOverides.remove(name);
        } else {
            this.headerOverides.put(name, value);
            if (name.equals("TestType")) {
                this.lastTestType = value.toString();
            }
        }
    }

    @Command(description="Set the directory into which FITS file will be stored")
    public void setFitsDirectory(String dir) {
        this.fitsDirectory = dir;
    }

    @Command(type=Command.CommandType.QUERY, description="retrieve the last acq test type")
    public String getLastTestType() {
        return this.lastTestType;
    }

    @Command(description="Set the file name into which FITS file will be stored")
    public void setFitsFilename(String fileName) {
        this.fitsFileName = fileName;
    }

    @Command(description="Set the file name into which FITS file will be stored")
    public void setCCDnum(String ccdnum) {
        this.fitsCCDnum = ccdnum;
    }

    @Command(description="Send archon configuration to controller and apply all. Resets timing core and powers off the ccd.")
    public void applyConfig() {
        if (this.cf == null) {
            throw new IllegalArgumentException("cannot apply config without having defined a configuration from an acf file ");
        }
        try {
            log.info((Object)"sending configuration to controller", new String[0]);
            this.ctl.writeConfigLines(this.cf.getLines());
            log.info((Object)"configuration sent to controller", new String[0]);
            this.ctl.applyAll();
            log.info((Object)"configuration applied to controller", new String[0]);
            Status s = new Status();
            s.setSummary("config applied");
            this.getSubsystem().broadcastStatus(s);
            this.publish("archonConfig", this.cf);
        }
        catch (DriverException e) {
            log.error((Object)"error sending config", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @ConfigChanger
    @Command(description="Send archon configuration to controller and apply params")
    public void applyParams() {
        if (this.cf == null) {
            throw new IllegalArgumentException("cannot apply params without having defined a configuration from an acf file ");
        }
        try {
            log.info((Object)"sending configuration to controller", new String[0]);
            this.ctl.writeConfigLines(this.cf.getLines());
            log.info((Object)"configuration sent to controller", new String[0]);
            this.ctl.loadParams();
            log.info((Object)"params configuration applied to controller", new String[0]);
            Status s = new Status();
            s.setSummary("params applied");
            this.getSubsystem().broadcastStatus(s);
            this.publish("archonConfig", this.cf);
        }
        catch (DriverException e) {
            log.error((Object)"error sending params", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="Send archon configuration to controller and reload timing scripts. Resets timing core.")
    public void applyTiming() {
        if (this.cf == null) {
            throw new IllegalArgumentException("cannot apply params without having defined a configuration from an acf file ");
        }
        try {
            log.info((Object)"sending configuration to controller", new String[0]);
            this.ctl.writeConfigLines(this.cf.getLines());
            log.info((Object)"configuration sent to controller", new String[0]);
            this.ctl.loadTiming();
            log.info((Object)"timing configuration applied to controller", new String[0]);
            Status s = new Status();
            s.setSummary("timing applied");
            this.getSubsystem().broadcastStatus(s);
            this.publish("archonConfig", this.cf);
        }
        catch (DriverException e) {
            log.error((Object)"error sending timing", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="Turn on the CCD")
    public void powerOnCCD() {
        try {
            this.ctl.powerOn();
            Status s = new Status();
            s.setSummary("CCD power on");
            this.getSubsystem().broadcastStatus(s);
        }
        catch (DriverException e) {
            log.error((Object)"error powering on CCD", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="Turn off the CCD")
    public void powerOffCCD() {
        try {
            this.ctl.powerOff();
            Status s = new Status();
            s.setSummary("CCD power off");
            this.getSubsystem().broadcastStatus(s);
        }
        catch (DriverException e) {
            log.error((Object)"error powering off CCD", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    public RawImageData acquireImage() {
        try {
            RawImageData imageData = this.ctl.fetchNewImage(this.fetch_timeout);
            if (this.inExposure) {
                this.inExposure = false;
                this.publish("inExposure", 0);
            }
            Status s = new Status();
            s.setSummary("Image acquired");
            this.getSubsystem().broadcastStatus(s);
            return imageData;
        }
        catch (DriverException e) {
            log.error((Object)"error acquiring image", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            log.error((Object)"timeout acquiring image", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="trigger image exposure and readout, and acquire the image w/o applying the whole config")
    public String exposeAcquireAndSaveWithoutApply() throws IOException, FitsException, DriverException {
        this.publish("inExposure", 1);
        this.inExposure = true;
        this.setAndApplyParam(this.acqParam, "1");
        return this.acquireAndSaveImage();
    }

    @Command(description="trigger image exposure and readout, and acquire the image")
    public String exposeAcquireAndSave() throws IOException, FitsException {
        this.publish("inExposure", 1);
        this.inExposure = true;
        this.setParameter(this.acqParam, "1");
        this.applyParams();
        return this.acquireAndSaveImage();
    }

    @Command(description="snap an image (filename, exptime (ms)")
    public String snap(@Argument(name="filename", description="filename with or without the full path") String fln, @Argument(name="exptime", description="exposure time in an integer number of msec") int exptime) throws IOException, FitsException {
        return this.snap(fln, exptime, 0, 0);
    }

    @Command(description="snap an image (filename, exptime (ms), light(1)/dark(0)")
    public String snap(@Argument(name="filename", description="filename with or without the full path") String fln, @Argument(name="exptime", description="exposure time in an integer number of msec") int exptime, @Argument(name="light", description="light(=1) or dark(=0) exposure") int light) throws IOException, FitsException {
        return this.snap(fln, exptime, light, 0);
    }

    @Command(description="snap an image (filename, exptime (ms), light(1)/dark(0), fe55(1),no fe55(0)")
    public String snap(@Argument(name="filename", description="filename with or without the full path") String fln, @Argument(name="exptime", description="exposure time in an integer number of msec") int exptime, @Argument(name="light", description="light(=1) or dark(=0) exposure") int light, @Argument(name="fe55", description="XED actuated(=1) or XED inactive(=0)") int fe55) throws IOException, FitsException {
        this.applyConfig();
        this.powerOnCCD();
        String[] splitfln = fln.split("/");
        String fln_name_only = splitfln[splitfln.length - 1];
        if (splitfln.length > 1) {
            this.setFitsDirectory(fln.substring(1, fln.length() - fln_name_only.length() - 1));
        }
        this.setFitsFilename(fln_name_only);
        this.setAcqParam("Nexpo");
        this.setParameter("Expo", "1");
        this.setParameter("ExpTime", String.valueOf(exptime));
        this.setParameter("Light", String.valueOf(light));
        this.setParameter("Fe55", String.valueOf(fe55));
        String fullfln = this.exposeAcquireAndSave();
        return "created fits file " + fullfln;
    }

    @Command(description="perform setup for acquisitions")
    public int eoSetup(@Argument(name="acffile", description="filename of acf file") String acffile, @Argument(name="ccdtype", description="filename of acf file") String ccdtype) throws IOException, FitsException {
        log.info((Object)"test stand in ready state, now the controller will be configured.", new String[0]);
        this.setDefaultCCDTypeName(ccdtype);
        log.info((Object)("initializing archon controller with file " + acffile), new String[0]);
        log.info((Object)"Loading configuration file into the Archon controller", new String[0]);
        this.setConfigFromFile(acffile);
        log.info((Object)"Applying configuration", new String[0]);
        this.applyConfig();
        log.info((Object)"Powering on the CCD", new String[0]);
        this.powerOnCCD();
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException ex) {
            log.error((Object)("Sleep interrupted: " + ex), new String[0]);
        }
        log.info((Object)"set controller parameters for an exposure with the shutter closed", new String[0]);
        this.setAcqParam("Nexpo");
        this.setParameter("Expo", "1");
        this.setParameter("Light", "1");
        this.setParameter("Fe55", "0");
        this.setFetch_timeout(500000L);
        return 1;
    }

    @Command(description="trigger image exposure and readout, for a series of images")
    public void exposeAcquireAndSaveSeveral(final int n) throws IOException, FitsException {
        this.publish("inExposure", 1);
        this.inExposure = true;
        this.inExposureSeries = true;
        this.setParameter(this.acqParam, Integer.toString(n));
        this.applyParams();
        final CCDGeometry ccdGeom = this.getCCDType().getGeometry();
        File dir = new File(this.fitsDirectory);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create or write to " + this.fitsDirectory);
        }
        final LinkedBlockingQueue<RawImageData> imageQueue = new LinkedBlockingQueue<RawImageData>();
        Runnable writer = new Runnable(){

            @Override
            public void run() {
                try {
                    int i = 0;
                    while (i < n) {
                        RawImageData d = (RawImageData)imageQueue.poll(10L, TimeUnit.SECONDS);
                        if (d == null) {
                            log.warn((Object)"no image in queue for saving, missed frames?", new String[0]);
                        } else {
                            log.info((Object)("  writer thread: saving frame " + d.getFrame()), new String[0]);
                            MetaDataSet metaDataSet = new MetaDataSet();
                            metaDataSet.addProperties("default", Archon.this.headerProperties);
                            metaDataSet.addMetaData("override", Archon.this.headerOverides);
                            Map statusAggregatorMetaData = Archon.this.sa.getAllLast();
                            statusAggregatorMetaData.put("ExposureTime", Double.valueOf(Archon.this.getParameter("ExpTime")) / 1000.0);
                            Long now = System.currentTimeMillis();
                            metaDataSet.addMetaData("StatusAggregator", statusAggregatorMetaData);
                            for (String k : statusAggregatorMetaData.keySet()) {
                                log.debug((Object)("got in SA " + k + " -> " + statusAggregatorMetaData.get(k)), new String[0]);
                            }
                            File outputFile = new File(Archon.this.fitsDirectory, Archon.this.escape(Archon.this.fitsFileName, now));
                            RawImageConverter converter = new RawImageConverter(d, ccdGeom);
                            Archon.this.imageHandler.writeImage(outputFile, converter, (Map<String, Map<String, Object>>)metaDataSet);
                            log.info((Object)("  writer thread: done saving to " + outputFile), new String[0]);
                        }
                        ++i;
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)"timeout exception in write queue", (Throwable)e, new String[0]);
                }
                catch (IOException | FitsException e) {
                    log.error((Object)"IO/FITS exception in write queue", e, new String[0]);
                }
            }
        };
        new Thread(writer).start();
        try {
            this.ctl.pollOff();
        }
        catch (DriverException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < n) {
            log.info((Object)"start aquire image", new String[0]);
            RawImageData rawImage = this.acquireImage();
            log.info((Object)("got frame " + rawImage.getFrame()), new String[0]);
            imageQueue.add(rawImage);
            log.info((Object)("queued for writing frame " + rawImage.getFrame()), new String[0]);
            ++i;
        }
        try {
            this.ctl.pollOff();
        }
        catch (DriverException e) {
            e.printStackTrace();
        }
        this.inExposureSeries = false;
    }

    @Command(description="acquire an image and save it to the default location")
    public String acquireAndSaveImage() throws IOException, FitsException {
        log.info((Object)("Received acquireAndSaveImage command for exptime= " + this.getParameter("ExpTime") + " and filename= " + this.fitsFileName), new String[0]);
        System.out.println("Received acquireAndSaveImage command for exptime= " + this.getParameter("ExpTime") + " and filename= " + this.fitsFileName);
        Date obsDate = new Date();
        RawImageData rawImage = this.acquireImage();
        MetaDataSet metaDataSet = new MetaDataSet();
        metaDataSet.addProperties("default", this.headerProperties);
        metaDataSet.addMetaData("override", this.headerOverides);
        Map statusAggregatorMetaData = this.sa.getAllLast();
        statusAggregatorMetaData.put("ExposureTime", Double.valueOf(this.getParameter("ExpTime")) / 1000.0);
        String[] cfln = this.configFileName.split("/");
        statusAggregatorMetaData.put("ConfigFile", cfln[cfln.length - 1]);
        if (!this.fitsCCDnum.isEmpty()) {
            statusAggregatorMetaData.put("CCDSerialManufacturer", this.fitsCCDnum);
        }
        Date fileDate = new Date();
        statusAggregatorMetaData.put("FileCreationDate", fileDate);
        statusAggregatorMetaData.put("ObservationDate", obsDate);
        String stampedFilename = "";
        if (!this.fitsFileName.isEmpty()) {
            stampedFilename = this.escape(this.fitsFileName, fileDate.getTime());
            statusAggregatorMetaData.put("OriginalFileName", stampedFilename);
        }
        metaDataSet.addMetaData("StatusAggregator", statusAggregatorMetaData);
        for (String k : statusAggregatorMetaData.keySet()) {
            log.debug((Object)("  got in SA " + k + " -> " + statusAggregatorMetaData.get(k)), new String[0]);
        }
        if (!this.fitsFileName.isEmpty()) {
            File dir = new File(this.fitsDirectory);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Unable to create or write to " + this.fitsDirectory);
            }
            File outputFile = new File(this.fitsDirectory, stampedFilename);
            RawImageConverter converter = new RawImageConverter(rawImage, this.getCCDType().getGeometry());
            this.imageHandler.writeImage(outputFile, converter, (Map<String, Map<String, Object>>)metaDataSet);
            log.info((Object)("Finished writing image to " + outputFile), new String[0]);
            Status s = new Status();
            s.setSummary("Image saved as " + outputFile);
            this.getSubsystem().broadcastStatus(s);
            if (this.sendImagesToDS9) {
                this.createSampUtils().display(outputFile);
            }
            this.imageAverageSignal = converter.getImageAverageSignal();
            return outputFile.getAbsolutePath();
        }
        return "";
    }

    @Command(description="get the average signal of the last image")
    public double getImageAverageSignal() {
        return this.imageAverageSignal;
    }

    @Command(description="Send a set command to DS9")
    public void ds9Set(String cmd, @Argument(name="url", defaultValue="") String arg) throws URISyntaxException, SampException {
        URI url = null;
        if (arg != null && !arg.isEmpty()) {
            url = new URI(arg);
        }
        this.createSampUtils().ds9Set(cmd, url, 10000);
    }

    @Command(description="Send a get command to DS9")
    public List<String> ds9Get(String cmd) throws SampException {
        List result = this.createSampUtils().ds9Get(cmd, 10000);
        return result.stream().map(item -> item.toString()).collect(Collectors.toList());
    }

    public List<String> ds9Versions() throws SampException {
        return this.createSampUtils().getDS9Version();
    }

    private SampUtils createSampUtils() {
        if (this.su == null) {
            this.su = new SampUtils("ArchonSubsystem", true);
            try {
                List dS9Version = this.su.getDS9Version();
                if (dS9Version.isEmpty()) {
                    log.warning((Object)"No DS9 is connected to SAMP hub, please start (or restart) ds9", new String[0]);
                }
            }
            catch (SampException x) {
                log.log(Level.WARNING, "Error while communicating with DS9", (Throwable)x, new String[0]);
            }
        }
        return this.su;
    }

    private String escape(String fitsFileName, Long timestamp) {
        return fitsFileName.replace("${timestamp}", String.valueOf(timestamp)).replace("${TIMESTAMP}", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(timestamp)));
    }

    @Command(description="get the timeout for fetching images in millisecs")
    public long getFetch_timeout() {
        return this.fetch_timeout;
    }

    @Command(description="set the timeout for fetching images in millisecs")
    public void setFetch_timeout(long fetch_timeout) {
        this.fetch_timeout = fetch_timeout;
    }

    @Command(description="is an exposure occuring")
    public boolean isInExposure() {
        return this.inExposure;
    }

    @Command(description="wait for an exposure to end")
    public int waitForExpoEnd() {
        int nsec = 0;
        while (true) {
            log.info((Object)("inExposure = " + this.inExposure), new String[0]);
            if (!this.inExposure) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                log.error((Object)"Sleep interrupted", (Throwable)ex, new String[0]);
            }
            ++nsec;
        }
        return nsec;
    }
}

