/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import org.astrogrid.samp.client.SampException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.drivers.archon.RawImageData;
import org.lsst.ccs.subsystem.archon.ImageHandler;
import org.lsst.ccs.subsystem.archon.RawImageConverter;
import org.lsst.ccs.utilities.ccd.CCDGeometry;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.image.ImageSet;

public class RawImageConverterTest {
    @Test
    public void testWriteITLFitsFile() throws IOException, FitsException {
        CCDGeometry ccdGeom = CCDType.ITL.getGeometry();
        File file = this.testWriteFitsFile("imageITL", ccdGeom, RawImageConverterTest.createStandardMetaData());
        System.out.println("testWriteFitsFile: " + file);
        RawImageConverterTest.testCheckSum(file);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Fits read = new Fits(file);){
            read.read();
            BasicHDU primary = read.getHDU(0);
            Assert.assertEquals((Object)"[1:4352,1:4096]", (Object)primary.getHeader().getStringValue("DETSIZE"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static Map<String, Map<String, Object>> createStandardMetaData() {
        HashMap<String, Comparable<Double>> extra = new HashMap<String, Comparable<Double>>();
        Date now = new Date();
        Date obs = new Date(now.getTime() - 2000L);
        extra.put("ExposureTime", Double.valueOf(15.0));
        extra.put("FileCreationDate", now);
        extra.put("ObservationDate", obs);
        HashMap<String, Map<String, Object>> metaDataMap = new HashMap<String, Map<String, Object>>();
        metaDataMap.put("extra", extra);
        return metaDataMap;
    }

    static void testCheckSum(File file) throws IOException {
        byte[] bytes = Files.readAllBytes(file.toPath());
        long checksum = FitsCheckSum.checksum((byte[])bytes);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)checksum);
    }

    @Test
    public void testWriteE2VFitsFile() throws IOException, FitsException {
        CCDGeometry ccdGeom = CCDType.E2V.getGeometry();
        File file = this.testWriteFitsFile("imageE2V", ccdGeom, RawImageConverterTest.createStandardMetaData());
        System.out.println("testWriteFitsFile: " + file);
        RawImageConverterTest.testCheckSum(file);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Fits read = new Fits(file);){
            read.read();
            BasicHDU primary = read.getHDU(0);
            Assert.assertEquals((Object)"[1:4352,1:4096]", (Object)primary.getHeader().getStringValue("DETSIZE"));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testFitsFileHeaders() {
        CCDGeometry ccdGeom = CCDType.E2V.getGeometry();
        RawImageData testImage = RawImageData.createRippledImage((CCDGeometry)ccdGeom);
        RawImageConverter converter = new RawImageConverter(testImage, ccdGeom);
        ImageSet imageSet = converter.getImageSet();
        for (ImageSet.Image image : imageSet.getImages()) {
            Map metaData = image.getMetaData();
            Map imageMetaData = (Map)metaData.get("channel");
            Assert.assertEquals((double)1000.0, (double)((Double)imageMetaData.get("AVERAGE")), (double)10.0);
            Assert.assertEquals((double)(200.0 / Math.sqrt(2.0)), (double)((Double)imageMetaData.get("STDEV")), (double)10.0);
            Assert.assertEquals((double)100.0, (double)((Double)imageMetaData.get("AVGBIAS")), (double)1.0);
            Assert.assertEquals((double)10.0, (double)((Double)imageMetaData.get("STDVBIAS")), (double)1.0);
        }
    }

    private File testWriteFitsFile(String name, CCDGeometry ccdGeom, Map<String, Map<String, Object>> metaDataMap) throws FitsException, IOException, SampException {
        RawImageData testImage = RawImageData.createRippledImage((CCDGeometry)ccdGeom);
        RawImageConverter converter = new RawImageConverter(testImage, ccdGeom);
        File tempFile = File.createTempFile(name, "fits");
        ImageHandler imageHandler = new ImageHandler();
        imageHandler.writeImage(tempFile, converter, metaDataMap);
        return tempFile;
    }
}

