/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.archon.RawImageData;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class RawImageConverter {
    private final DefaultImageSet imageSet;
    private final RawImageData rawImage;
    private static final int segmentWidth = 2002;
    private static final int segmentHeight = 512;
    private static final int horizontalSegmentCount = 8;
    private static final int verticalSegmentCount = 2;
    private static final int prescan = 10;
    private static final int overscan = 22;
    private static final int parallelOverscan = 46;
    private static final boolean flipReadoutOrder = false;
    private static final int totalSegmentWidth = 2048;
    private static final int totalSegmentHeight = 544;
    private static final int BUFFER_SIZE = 1000000;

    RawImageConverter(RawImageData rawImage) {
        assert (rawImage.data.length == rawImage.mode.bytes() * 8 * 2 * 544 * 2048);
        this.rawImage = rawImage;
        HashMap<String, RawImageData.Mode> metaData = new HashMap<String, RawImageData.Mode>();
        metaData.put("mode", rawImage.mode);
        this.imageSet = new DefaultImageSet(metaData);
        int v = 0;
        while (v < 2) {
            int h = 0;
            while (h < 8) {
                MetaDataSet metaDataSet = new MetaDataSet();
                HashMap<String, Object> imageMetaData = new HashMap<String, Object>();
                int vSegment = this.getVSegment(h, v);
                int hSegment = this.getHSegment(h, v);
                imageMetaData.put("EXTNAME", "Segment" + vSegment + hSegment);
                imageMetaData.put("CHANNEL", this.getChannel(h, v));
                imageMetaData.put("DETSIZE", this.pair(this.range(1, 4096), this.range(1, 4004)));
                imageMetaData.put("DATASEC", this.pair(this.range(11, 522), this.range(1, 2002)));
                imageMetaData.put("DETSEC", this.pair(this.range(512 * hSegment + 1, 512 * (hSegment + 1), false), this.range(2002 * v + 1, 2002 * (v + 1), false)));
                imageMetaData.put("CCDSUM", "1 1");
                metaDataSet.addMetaData("channel", imageMetaData);
                this.imageSet.addImage(544, 2048, (Map)metaDataSet);
                ++h;
            }
            ++v;
        }
    }

    private int getChannel(int h, int v) {
        return 1 + v * 8 + h;
    }

    private int getVSegment(int h, int v) {
        return 1 - v;
    }

    private int getHSegment(int h, int v) {
        return v == 0 ? h : 8 - h - 1;
    }

    private String pair(String a, String b) {
        return "[" + a + "," + b + "]";
    }

    private String range(int a, int b) {
        return String.valueOf(a) + ":" + b;
    }

    private String range(int a, int b, boolean flip) {
        return flip ? this.range(b, a) : this.range(a, b);
    }

    ImageSet getImageSet() {
        return this.imageSet;
    }

    void pushDataToFile(FitsFileWriter writer) throws IOException {
        ByteBuffer src = ByteBuffer.wrap(this.rawImage.data);
        ByteBuffer[] dest = new ByteBuffer[8];
        int h = 0;
        while (h < 8) {
            dest[h] = ByteBuffer.allocate(1000000);
            ++h;
        }
        int v = 0;
        while (v < 2) {
            int r = 0;
            while (r < 2048) {
                int h2 = 0;
                while (h2 < 8) {
                    src.limit(src.position() + 544 * this.rawImage.mode.bytes());
                    if (dest[h2].remaining() < src.remaining()) {
                        this.flush(h2, v, dest, writer);
                    }
                    dest[h2].put(src);
                    ++h2;
                }
                ++r;
            }
            int h3 = 0;
            while (h3 < 8) {
                this.flush(h3, v, dest, writer);
                ++h3;
            }
            ++v;
        }
        assert (src.position() == src.limit());
    }

    private void flush(int h, int v, ByteBuffer[] dest, FitsFileWriter writer) throws IOException {
        int imageId = v == 0 ? 8 - this.getChannel(h, v) : this.getChannel(h, v) - 1;
        dest[h].flip();
        writer.write(imageId, dest[h]);
        dest[h].clear();
    }
}

