/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import nom.tam.fits.FitsException;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;
import org.lsst.ccs.bus.MessagingFactory;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.StatusAggregator;
import org.lsst.ccs.bus.StatusListens;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.archon.ArchonController;
import org.lsst.ccs.drivers.archon.ArchonControllerDriver;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.drivers.archon.DummyArchonController;
import org.lsst.ccs.drivers.archon.RawImageData;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.subsystem.archon.ImageHandler;
import org.lsst.ccs.subsystem.archon.RawImageConverter;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.MetaDataSet;

public class Archon
extends Module {
    private final ArchonController ctl;
    private ArchonConfiguration cf;
    private final StatusAggregator sa = new StatusAggregator();
    private String fitsDirectory = ".";
    private ImageHandler imageHandler;
    private Properties headerProperties;
    private final Map<String, Object> headerOverides = new HashMap<String, Object>();

    public Archon(String name, int tickMillis, String ip) {
        super(name, tickMillis);
        try {
            this.ctl = ip == null ? new DummyArchonController() : new ArchonControllerDriver(ip);
        }
        catch (DriverException e) {
            throw new RuntimeException(e);
        }
    }

    public void initModule() {
        MessagingFactory.getInstance().forSubsystem("archon-sl").addStatusListener((StatusListens)this.sa);
        this.imageHandler = new ImageHandler();
        for (HeaderSpecification spc : this.imageHandler.getConfig().values()) {
            for (HeaderSpecification.HeaderLine l : spc.getHeaders()) {
                String meta = l.getMetaName();
                if (meta == null || !meta.contains("/")) continue;
                log.info((Object)("adding " + meta + " to agregator"), new String[0]);
                this.sa.setAggregate(meta, -1, -1);
            }
        }
        this.headerProperties = BootstrapResourceUtils.getBootstrapProperties((String)"header.properties");
    }

    public void tick() {
        try {
            ArchonStatus st = this.ctl.getStatus();
            log.info((Object)("sending status, backplane temp = " + st.backplaneTemp), new String[0]);
            this.publish("archonStatus", st);
            Status s = new Status();
            s.setSummary("archon tick");
            this.getSubsystem().broadcastStatus(s);
        }
        catch (DriverException e) {
            log.error((Object)"error reading status", (Throwable)e, new String[0]);
        }
    }

    @ConfigChanger
    public void setConfigFromFile(String fn) {
        try {
            this.cf = new ArchonConfiguration(fn);
            log.info((Object)"config read", new String[0]);
            Status s = new Status();
            s.setSummary("config read");
            this.getSubsystem().broadcastStatus(s);
        }
        catch (IOException e) {
            log.error((Object)"error reading config", (Throwable)e, new String[0]);
        }
    }

    @ConfigChanger
    public void setAndApplyConfig(ArchonConfiguration c) {
        this.setConfig(c);
        this.applyConfig();
    }

    @ConfigChanger
    public void setConfig(ArchonConfiguration c) {
        this.cf = c;
        log.info((Object)"config updated", new String[0]);
        Status s = new Status();
        s.setSummary("config updated");
        this.getSubsystem().broadcastStatus(s);
    }

    @Command(description="Get the archon controller status")
    public ArchonStatus getControllerStatus() {
        try {
            log.info((Object)"get controller status", new String[0]);
            return this.ctl.getStatus();
        }
        catch (DriverException e) {
            log.error((Object)"error getting status", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @ConfigChanger
    @Command(description="Set an archon configuration parameter")
    public void setParameter(String name, String value) {
        this.cf.setParameter(name, value);
    }

    @ConfigChanger
    @Command(description="Set an archon configuration constant")
    public void setConstant(String name, String value) {
        this.cf.setConstant(name, value);
    }

    @Command(description="Overide a FITS header")
    public void setHeader(@Argument(name="name") String name, @Argument(name="value", defaultValue="") String value) {
        if (value == null || value.isEmpty()) {
            this.headerOverides.remove(name);
        } else {
            this.headerOverides.put(name, value);
        }
    }

    @ConfigChanger
    @Command(description="Set the directory into which FITS file will be stored")
    public void setFitsDirectory(String dir) {
        this.fitsDirectory = dir;
    }

    @ConfigChanger
    @Command(description="Send archon configuration to controller")
    public void applyConfig() {
        try {
            log.info((Object)"sending configuration to controller", new String[0]);
            this.ctl.writeConfigLines(this.cf.getLines());
            log.info((Object)"configuration sent to controller", new String[0]);
            this.ctl.applyAll();
            log.info((Object)"configuration applied to controller", new String[0]);
            Status s = new Status();
            s.setSummary("config applied");
            this.getSubsystem().broadcastStatus(s);
            this.publish("archonConfig", this.cf);
        }
        catch (DriverException e) {
            log.error((Object)"error sending config", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="Turn on the CCD")
    public void powerOnCCD() {
        try {
            this.ctl.powerOn();
            Status s = new Status();
            s.setSummary("CCD power on");
            this.getSubsystem().broadcastStatus(s);
        }
        catch (DriverException e) {
            log.error((Object)"error powering on CCD", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="Turn off the CCD")
    public void powerOffCCD() {
        try {
            this.ctl.powerOff();
            Status s = new Status();
            s.setSummary("CCD power off");
            this.getSubsystem().broadcastStatus(s);
        }
        catch (DriverException e) {
            log.error((Object)"error powering off CCD", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    public RawImageData acquireImage() {
        try {
            RawImageData imageData = this.ctl.fetchNewImage(5000L);
            Status s = new Status();
            s.setSummary("Image acquired");
            this.getSubsystem().broadcastStatus(s);
            return imageData;
        }
        catch (DriverException e) {
            log.error((Object)"error acquiring image", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            log.error((Object)"timeout acquiring image", (Throwable)e, new String[0]);
            throw new RuntimeException(e);
        }
    }

    @Command(description="acquire an image and save it to the hardwired location")
    public void acquireAndSaveImage() throws IOException, FitsException {
        log.info((Object)"Received acquireAndSaveImage command", new String[0]);
        String fileNameTemplate = "%s/ArchonImageFile_%d.fits";
        Long timestamp = System.currentTimeMillis();
        String fileName = String.format(fileNameTemplate, this.fitsDirectory, timestamp);
        MetaDataSet metaDataSet = new MetaDataSet();
        metaDataSet.addProperties("default", this.headerProperties);
        metaDataSet.addMetaData("override", this.headerOverides);
        Map statusAggregatorMetaData = this.sa.getAllLast();
        metaDataSet.addMetaData("StatusAggregator", statusAggregatorMetaData);
        for (String k : statusAggregatorMetaData.keySet()) {
            log.info((Object)("got in SA " + k + " -> " + statusAggregatorMetaData.get(k)), new String[0]);
        }
        RawImageConverter converter = new RawImageConverter(this.acquireImage());
        this.imageHandler.writeImage(fileName, converter, (Map<String, Map<String, Object>>)metaDataSet);
        log.info((Object)("Finished writing image to " + fileName), new String[0]);
    }
}

