/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.archon.ui;

import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.archon.data.ArchonControllerStatus;
import org.lsst.ccs.subsystem.archon.ui.ArchonStatusPanel;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;
import org.lsst.ccs.utilities.logging.Logger;

public class ArchonGUI
implements StatusMessageListener,
AgentPresenceListener {
    private static String archon_dest = "archon";
    private String stateCorrelId;
    private MonitorTrendingTable table;
    private final CommandOriginator commandOriginator;
    private final AgentMessagingLayer agentMessagingLayer;
    private final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.archon.ui.ArchonGUI");
    ArchonStatusPanel statusPanel = new ArchonStatusPanel(this);

    public ArchonGUI(AgentMessagingLayer agentMessagingLayer) {
        this.agentMessagingLayer = agentMessagingLayer;
        agentMessagingLayer.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        BusMessageFilter filter = BusMessageFilter.messageOrigin((String)archon_dest).and(BusMessageFilter.messageClass(StatusSubsystemData.class));
        agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this, (Predicate)filter);
        System.out.println("ArchonGUI: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        this.commandOriginator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processResult(CommandResult result) {
                ArchonGUI.this.log.info((Object)("Got command result " + result));
            }
        };
    }

    public void onStatusMessage(StatusMessage msg) {
        StatusSubsystemData ssd = (StatusSubsystemData)msg;
        KeyValueData msgObject = ssd.getSubsystemData();
        if (msgObject instanceof KeyValueData) {
            KeyValueData d = msgObject;
            this.log.info((Object)("ArchonGUI: In onStatusMessage method. KEY=" + d.getKey()));
            if (d.getKey().equals("archonControllerStatus") && d.getValue() instanceof ArchonStatus) {
                this.onArchonStatus(msg.getTimeStamp(), (ArchonControllerStatus)d.getValue());
            } else if (!d.getKey().equals("archonConfig") || d.getValue() instanceof ArchonConfiguration) {
                // empty if block
            }
        }
    }

    public void onArchonStatus(long timestamp, ArchonControllerStatus st) {
        this.statusPanel.updatePanel(st);
    }

    public void connecting(AgentInfo agent) {
        if (agent.getName().equals(archon_dest)) {
            // empty if block
        }
    }

    public void disconnecting(AgentInfo agent) {
    }

    protected Object sendSyncArchonCommand(String name, Object ... params) {
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(archon_dest, name, params);
        try {
            return cmu.sendSynchronousCommand(cmd, 10000L);
        }
        catch (Exception e) {
            this.log.warning((Object)("Unable to perform jgroup communication with destination + " + archon_dest + " - Exception " + e));
            return null;
        }
    }

    public JComponent getGuiLayout() {
        return this.statusPanel;
    }

    public void initGui() {
        System.out.println("initGui: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        System.out.println("archon_dest = " + archon_dest);
    }

    public static void main(String[] args) {
        BusMaster bm = new BusMaster("ArchonGUI");
        ArchonGUI gui = new ArchonGUI(bm.getMessagingAccess());
        JFrame f = new JFrame();
        JScrollPane scroll = new JScrollPane(gui.statusPanel);
        f.setContentPane(scroll);
        f.pack();
        f.setVisible(true);
    }

    private CommandOriginator getCommandOriginator() {
        CommandOriginator originator = new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processResult(CommandResult result) {
            }
        };
        return originator;
    }
}

