package org.lsst.ccs.subsystem.archon.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.NumberFormatter;

import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.subsystem.archon.data.ArchonControllerStatus;

public class ArchonStatusPanel extends JPanel {

    JTabbedPane tabs = new JTabbedPane();

    JPanel monitoringPanel = new JPanel();

    JFormattedTextField tfBackPlaneTemp;
    JLabel lbBackPlaneTemp = new JLabel("Backplane temp");

    JButton btLoadFile = new JButton("load config file");
    JButton btApplyConfig = new JButton("apply config");
    JButton btApplyParams = new JButton("apply parameters");

    // parameters and constants table
    String[] parmNames = new String[0];

    AbstractTableModel paramModel = new AbstractTableModel() {
        @Override
        public String getColumnName(int column) {
            return (column == 0) ? "name" : "value";
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return acf == null ? 0 : acf.getParameters().size();
        }

        public void fireTableDataChanged() {
            parmNames = acf.getParameters().toArray(new String[0]);
            super.fireTableDataChanged();
        }

        public Object getValueAt(int row, int col) {
            if (col == 0)
                return parmNames[row];

            return acf.getParameter(parmNames[row]);
        }
    };
    JTable table = new JTable(paramModel);
    JScrollPane scrollpane = new JScrollPane(table);

    JPanel buttons = new JPanel();

    NumberFormatter fmt7_3 = new NumberFormatter(new DecimalFormat("##0.0##"));
    private final ArchonGUI gui;
    ArchonConfiguration acf;

    public ArchonStatusPanel(ArchonGUI theGui) {
        this.gui = theGui;

        table.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JTable target = (JTable) e.getSource();
                    int row = target.getSelectedRow();
                    //int column = target.getSelectedColumn();
                    String paramName = parmNames[row];
                    String value = acf.getParameter(paramName);
                    value = JOptionPane.showInputDialog(ArchonStatusPanel.this,
                            paramName, value);
                    if (value != null)
                        acf.setParameter(paramName, value);
                }
            }
        });

        setLayout(new BorderLayout());

        add(tabs, BorderLayout.CENTER);

        buttons.add(btLoadFile);
        buttons.add(btApplyConfig);
        buttons.add(btApplyParams);

        add(buttons, BorderLayout.SOUTH);

        fmt7_3.setValueClass(Float.class);

        tfBackPlaneTemp = new JFormattedTextField(fmt7_3);
        Dimension d = tfBackPlaneTemp.getPreferredSize();
        d.width = 100;
        tfBackPlaneTemp.setPreferredSize(d);
        tfBackPlaneTemp.setMinimumSize(d);
        tfBackPlaneTemp.setEditable(false);

        monitoringPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        monitoringPanel.add(lbBackPlaneTemp, gbc);
        gbc.gridx++;
        monitoringPanel.add(tfBackPlaneTemp, gbc);

        tabs.add("monitoring", monitoringPanel);
        tabs.add("parameters", scrollpane);

        /*
         * gbc.gridx = 0; gbc.gridy = 1; gbc.gridwidth = 2; gbc.gridheight = 4;
         * add(scrollpane, gbc);
         * 
         * gbc.gridx = 0; gbc.gridy = 5; gbc.gridwidth = 1; gbc.gridheight = 1;
         * add(btLoadFile, gbc); gbc.gridx++; add(btApplyConfig, gbc);
         */

        btLoadFile.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter(
                        "Archon configuration files", "acf");
                fc.setFileFilter(filter);
                int returnVal = fc.showOpenDialog(ArchonStatusPanel.this);
                if (returnVal == JFileChooser.APPROVE_OPTION) {

                    try {
                        acf = new ArchonConfiguration(fc.getSelectedFile());
                        paramModel.fireTableDataChanged();

                    } catch (IOException e1) {
                        // TODO Auto-generated catch block
                        e1.printStackTrace();
                    }
                }
            }
        });

        btApplyConfig.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                gui.sendSyncArchonCommand("setAndApplyConfig", acf);

            }
        });
        
        btApplyParams.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                gui.sendSyncArchonCommand("setAndApplyParams", acf);

            }
        });

    }

    public void updatePanel(final ArchonControllerStatus st) {
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                doUpdatePanel(st);
            }

        });
    }

    // on swing thread
    private void doUpdatePanel(ArchonControllerStatus st) {
        tfBackPlaneTemp.setValue(st.getBackplaneTemp());
    }
}
