package org.lsst.ccs.subsystem.archon.ui;

import java.io.Serializable;
import java.time.Duration;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.CommandOriginator;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.drivers.archon.ArchonStatus;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.archon.data.ArchonConfiguration;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.subsystem.archon.data.ArchonControllerStatus;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;
import org.lsst.ccs.subsystem.monitor.ui.MonitorAssembly;
import org.lsst.ccs.subsystem.monitor.ui.MonitorTrendingTable;
import org.lsst.ccs.utilities.tracers.Names;

import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
// -----------------

public class ArchonGUI implements StatusMessageListener, AgentPresenceListener {

    private static String archon_dest = "archon";
    private String stateCorrelId;
//m    private final MonitorAssembly mon;
    private MonitorTrendingTable table;

    private final CommandOriginator commandOriginator;

    private final AgentMessagingLayer agentMessagingLayer;
    private final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.archon.ui.ArchonGUI");

    public ArchonGUI(AgentMessagingLayer agentMessagingLayer) {
        this.agentMessagingLayer = agentMessagingLayer;

        agentMessagingLayer.getAgentPresenceManager()
                .addAgentPresenceListener(this);

        // register ourselves as a status listener of StatusSubsystemData coming from teststand_dest only
        Predicate<BusMessage<? extends Serializable, ?>> filter = BusMessageFilterFactory.
                messageOrigin(archon_dest).and(BusMessageFilterFactory.messageClass(StatusSubsystemData.class));

        agentMessagingLayer.addStatusMessageListener(this, filter);

        System.out.println(
                "ArchonGUI: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
//m        mon = new MonitorAssembly(this);

        commandOriginator = new CommandOriginator() {

            @Override
            public void processAck(CommandAck ack) {
            }

            @Override
            public void processNack(CommandNack nack) {
            }

            @Override
            public void processResult(CommandResult result) {
                log.info("Got command result " + result);
            }

        };

    }

    ArchonStatusPanel statusPanel = new ArchonStatusPanel(this);

    @Override
    public void onStatusMessage(StatusMessage msg
    ) {
//        System.out.println("GUI: In onDataArrival method and the source is "+source);

        StatusSubsystemData ssd = (StatusSubsystemData)msg;
        Object msgObject = ssd.getSubsystemData();
        if (msgObject instanceof KeyValueData) {
            KeyValueData d = (KeyValueData) msgObject;
            log.info("ArchonGUI: In onStatusMessage method. KEY=" + d.getKey());
            if (d.getKey().equals("archonControllerStatus") && d.getValue() instanceof ArchonStatus) {
                onArchonStatus(msg.getTimeStamp(), (ArchonControllerStatus) d.getValue());
            } else if (d.getKey().equals("archonConfig")
                    && d.getValue() instanceof ArchonConfiguration) {

            }

        }
//m        mon.handleData(archon_dest, ssd.getDataKey(), ssd.getSubsystemData());
    }

    public void onArchonStatus(long timestamp, ArchonControllerStatus st) {
        statusPanel.updatePanel(st);
    }

        @Override
    public void connecting(AgentInfo agent) {
        //Initialize the GUI when the teststand subsystem connects to the buses
        if (agent.getName().equals(archon_dest)) {
//            initConfigs();
        }
    }

    @Override
    public void disconnecting(AgentInfo agent) {
        //Put code here to reset the GUI when the teststand subsystem disconnects from the buses
    }

    protected Object sendSyncArchonCommand(String name, Object... params) {
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(agentMessagingLayer);
        CommandRequest cmd = new CommandRequest(archon_dest, name, params);
        try {
            return cmu.sendSynchronousCommand(cmd, Duration.ofMillis(10000));
        } catch (Exception e) {
            log.warning("Unable to perform jgroup communication with destination + "
                    + archon_dest + " - Exception " + e);
            return null;
        }
    }

    public JComponent getGuiLayout() {
        return statusPanel;
    }

    public void initGui() {
        System.out.println("initGui: Retrieving archon name on the bus from property lsst.ccs.teststand.tsguidest");
        archon_dest = System.getProperty("lsst.ccs.archon.archonguidest", "archon2");
        System.out.println("archon_dest = " + archon_dest);
//m        mon.setSubsystems(archon_dest);
//        setName(Names.almostUniqueAgentName("ArchonGUI"));
//        setStatusBroadcastPeriod(1000);
//        setListenToStatus(true);

//        initComponents();
//m        table = new MonitorTrendingTable(this);
//        start();
    }

    public static void main(String[] args) {
        BusMaster bm = new BusMaster("ArchonGUI");
        ArchonGUI gui = new ArchonGUI(bm.getMessagingAccess());

        JFrame f = new JFrame();

        JScrollPane scroll = new JScrollPane(gui.statusPanel);
        f.setContentPane(scroll);

        f.pack();
        f.setVisible(true);

    }

    private CommandOriginator getCommandOriginator() {
        CommandOriginator originator = new CommandOriginator() {

            @Override
            public void processAck(CommandAck ack) {
            }


            @Override
            public void processNack(CommandNack nack) {
            }

            @Override
            public void processResult(CommandResult result) {
//        panel.updateTime();
//                enabled = true;
            }

        };
        return originator;
    }

}
